% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_rasters.R
\name{scale_rasters}
\alias{scale_rasters}
\title{Scale a set of rasters}
\usage{
scale_rasters(raster_list, reference_resolution = NULL)
}
\arguments{
\item{raster_list}{a list of raster objects.}

\item{reference_resolution}{the resolution to resample the rasters to.}
}
\value{
a list of scaled raster objects.
}
\description{
Scale a set of rasters
}
\examples{
# Create two example rasters
rast_a <- terra::rast(
  ncol = 10, nrow = 10,
  xmin = 0, xmax = 10,
  ymin = 0, ymax = 10,
  vals = runif(100)
)

rast_b <- terra::rast(
  ncol = 10, nrow = 10,
  xmin = 0, xmax = 10,
  ymin = 0, ymax = 10,
  vals = runif(100)
)

# Scale example rasters in a list
rast_list <- list(rast_a, rast_b)
scale_rasters(rast_list)

}
