% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxd.R
\name{Dprime}
\alias{Dprime}
\title{Get the standardized composite D'.}
\usage{
Dprime(qmat, type = c("allele", "geno"), constrain = FALSE)
}
\arguments{
\item{qmat}{The observed joint genotype distribution.}

\item{type}{Should we condition on the marginal genotype distribution
(\code{type = "geno"}), or should we condition on the allele frequency
(\code{type = "allele"})?}

\item{constrain}{A logical. This option is only applicable when
\code{type = "allele"}. Should return an value that is equal
to D' under HWE (\code{FALSE}) or a value that is constrained
to lie between -1 and 1 (\code{TRUE})? Defaults to \code{FALSE}.}
}
\value{
A vector of length 2. The first element is the estimated
D'. The second element is the normalization used.
}
\description{
This function will either standardize by the maximum covariance
conditional on the marginal genotype distribution, or by the
maximum covariance conditional on the marginal allele frequencies.
}
\details{
Note that when \code{type = "allele"} and \code{constrain = FALSE},
the resulting D' is constrained to fall between -K and K, where
K is the ploidy of the species. However, under HWE, this measure is
equal to gametic D'. Using \code{constrain = TRUE} will result
in a measure that is constrained to lie between -1 and 1, but
it will not equal gametic D' under HWE.

Using \code{type = "geno"} is its own thing and will not equal
D' generally under HWE. When \code{type = "geno"}, then the
the \code{constrain} parameter has no effect.
}
\examples{
K <- 6
qmat <- matrix(stats::runif((K+1)^2), nrow = K+1)
qmat <- qmat / sum(qmat)
Dprime(qmat, type = "geno")
Dprime(qmat, type = "allele")

}
\author{
David Gerard
}
