% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Leafdown.R
\name{Leafdown}
\alias{Leafdown}
\title{Leafdown R6 Class}
\description{
This class acts as a wrapper around a leafdown map.
}
\examples{
\dontrun{

library(leafdown)
library(leaflet)
library(shiny)
library(dplyr)
library(shinyjs)

ger1 <- raster::getData(country = "Germany", level = 1)
ger2 <- raster::getData(country = "Germany", level = 2)
spdfs_list <- list(ger1, ger2)

ui <- shiny::fluidPage(
  useShinyjs(),
  actionButton("drill_down", "Drill Down"),
  actionButton("drill_up", "Drill Up"),
  leafletOutput("leafdown")
)

server <- function(input, output) {
  my_leafdown <- Leafdown$new(spdfs_list, "leafdown", input)
  update_leafdown <- reactiveVal(0)

  observeEvent(input$drill_down, {
    my_leafdown$drill_down()
    update_leafdown(update_leafdown() + 1)
  })

  observeEvent(input$drill_up, {
    my_leafdown$drill_up()
   update_leafdown(update_leafdown() + 1)
 })

  output$leafdown <- renderLeaflet({
    update_leafdown()
    meta_data <- my_leafdown$curr_data
    curr_map_level <- my_leafdown$curr_map_level
    if (curr_map_level == 1) {
      data <- meta_data \%>\%
        left_join(gdp_2014_federal_states, by = c("NAME_1" = "Federal_State"))
    } else {
      data <- meta_data \%>\%
        left_join(gdp_2014_admin_districts, by = c("NAME_2" = "Admin_District"))
    }

    my_leafdown$add_data(data)
    my_leafdown$draw_leafdown(
      fillColor = ~ colorNumeric("Greens", GDP_2014)(GDP_2014), weight = 2, color = "grey"
    )
  })
}

shinyApp(ui, server)

}

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{curr_sel_data}}{A \code{reactiveValue} containing a data.frame with
the metadata and (if available) the corresponding values of all currently selected shapes.}

\item{\code{curr_data}}{The metadata and (if available) the corresponding values of all currently displayed shapes.}

\item{\code{curr_map_level}}{Index of the current map level.
This corresponds to the position of the shapes in the \code{spdfs_list}.
(i.e The highest-level is 1, the next is 2 and so on...).}

\item{\code{curr_poly_ids}}{The ids of all polygons of the current map level.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Leafdown$new()}}
\item \href{#method-draw_leafdown}{\code{Leafdown$draw_leafdown()}}
\item \href{#method-keep_zoom}{\code{Leafdown$keep_zoom()}}
\item \href{#method-add_data}{\code{Leafdown$add_data()}}
\item \href{#method-drill_down}{\code{Leafdown$drill_down()}}
\item \href{#method-drill_up}{\code{Leafdown$drill_up()}}
\item \href{#method-toggle_shape_select}{\code{Leafdown$toggle_shape_select()}}
\item \href{#method-clone}{\code{Leafdown$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes the leafdown object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$new(spdfs_list, map_output_id, input, join_map_levels_by = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spdfs_list}}{A list with the spdfs of all map levels. This cannot be changed later.}

\item{\code{map_output_id}}{The id from the shiny-ui used in the \code{leafletOutput("<<id>>")}.
Used to observe for _shape_click events.}

\item{\code{input}}{The \code{input} from the shiny app.}

\item{\code{join_map_levels_by}}{A named vector of length \code{length(spdfs_list) - 1} with the columns by which the map
levels should be joined. The first element defines how the first and second map levels should be joined, the second
element does the same for the second and third map levels and so on. The name of an element defines the name of
the join column in the upper map level and the actual element the join column of the lower map level.
By default this is set to c("GID_0" = "GID_0", "GID_1" = "GID_1", ..., "GID_n" = "GID_n"),
where n is \code{length(spdfs_list) - 1}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-draw_leafdown"></a>}}
\if{latex}{\out{\hypertarget{method-draw_leafdown}{}}}
\subsection{Method \code{draw_leafdown()}}{
Draws the leaflet map on the current map level. All unselected parents will be drawn in gray.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$draw_leafdown(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments given to \code{leaflet::addPolygons}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_zoom"></a>}}
\if{latex}{\out{\hypertarget{method-keep_zoom}{}}}
\subsection{Method \code{keep_zoom()}}{
Keeps the zoom after \code{drill_down} and \code{drill_up} events.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$keep_zoom(map, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{map}}{the map output from \code{draw_leafdown}}

\item{\code{input}}{the input object from the shiny app}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-add_data}{}}}
\subsection{Method \code{add_data()}}{
Adds the data to the currently displayed shapes.
This includes the meta-data AND the values to be visualized in the map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$add_data(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The new data existing of the meta-data and the values to display in the map(color)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-drill_down"></a>}}
\if{latex}{\out{\hypertarget{method-drill_down}{}}}
\subsection{Method \code{drill_down()}}{
Drills down to the lower level if:
\itemize{
 \item there is a lower level (for now there are only two levels)
 \item at least one shape is selected to drill down on
}
This will not redraw the map. Also call \code{add_data} to add data for the new level and then
  \code{draw_leafdown} to redraw the map on the new level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$drill_down()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-drill_up"></a>}}
\if{latex}{\out{\hypertarget{method-drill_up}{}}}
\subsection{Method \code{drill_up()}}{
Drills up to the higher level if:
\itemize{
 \item there is a higher level (for now there are only two levels)
}
This will not redraw the map. Also call \code{add_data} to add data for the new level and then
  \code{draw_leafdown} to redraw the map on the new level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$drill_up()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toggle_shape_select"></a>}}
\if{latex}{\out{\hypertarget{method-toggle_shape_select}{}}}
\subsection{Method \code{toggle_shape_select()}}{
Selects the shape with the given shape id, or unselects it if it was already selected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$toggle_shape_select(shape_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shape_id}}{the id of the shape to select, has to be a character and in the current map-level.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Leafdown$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
