% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{addLeafLegends}
\alias{addLeafLegends}
\alias{addLegendNumeric}
\alias{addLegendQuantile}
\alias{addLegendBin}
\alias{addLegendFactor}
\title{Add Customizable Color Legends to a 'leaflet' map widget}
\usage{
addLegendNumeric(
  map,
  pal,
  values,
  title = NULL,
  shape = c("rect", "stadium"),
  orientation = c("vertical", "horizontal"),
  width = 20,
  height = 100,
  bins = 7,
  numberFormat = function(x) {
     prettyNum(x, format = "f", big.mark = ",", digits =
    3, scientific = FALSE)
 },
  tickLength = 4,
  tickWidth = 1,
  decreasing = FALSE,
  fillOpacity = 1,
  group = NULL,
  labels = NULL,
  naLabel = "NA",
  className = "info legend leaflet-control",
  data = leaflet::getMapData(map),
  ...
)

addLegendQuantile(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = "rect",
  orientation = c("vertical", "horizontal"),
  width = 24,
  height = 24,
  numberFormat = function(x) {
     prettyNum(x, big.mark = ",", scientific = FALSE,
    digits = 1)
 },
  opacity = 1,
  fillOpacity = opacity,
  group = NULL,
  className = "info legend leaflet-control",
  naLabel = "NA",
  data = leaflet::getMapData(map),
  ...
)

addLegendBin(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = "rect",
  orientation = c("vertical", "horizontal"),
  width = 24,
  height = 24,
  numberFormat = function(x) {
     format(round(x, 3), big.mark = ",", trim = TRUE,
    scientific = FALSE)
 },
  opacity = 1,
  fillOpacity = opacity,
  group = NULL,
  className = "info legend leaflet-control",
  naLabel = "NA",
  data = leaflet::getMapData(map),
  ...
)

addLegendFactor(
  map,
  pal,
  values,
  title = NULL,
  labelStyle = "",
  shape = "rect",
  orientation = c("vertical", "horizontal"),
  width = 24,
  height = 24,
  opacity = 1,
  fillOpacity = opacity,
  group = NULL,
  className = "info legend leaflet-control",
  naLabel = "NA",
  data = leaflet::getMapData(map),
  ...
)
}
\arguments{
\item{map}{a map widget object created from 'leaflet'}

\item{pal}{the color palette function, generated from \link[leaflet]{colorNumeric}}

\item{values}{the values used to generate colors from the palette function}

\item{title}{the legend title, pass in HTML to style}

\item{shape}{the desired shape of the symbol, See \link[leaflegend]{availableShapes}}

\item{orientation}{stack the legend items vertically or horizontally}

\item{width}{in pixels}

\item{height}{in pixels}

\item{bins}{an approximate number of tick-marks on the color gradient for the
colorNumeric palette}

\item{numberFormat}{formatting functions for numbers that are displayed e.g. format, prettyNum}

\item{tickLength}{in pixels}

\item{tickWidth}{in pixels}

\item{decreasing}{order of numbers in the legend}

\item{fillOpacity}{fill opacity of the legend items}

\item{group}{group name of a leaflet layer group}

\item{labels}{labels}

\item{naLabel}{the legend label for NAs in values}

\item{className}{extra CSS class to append to the control, space separated}

\item{data}{a data object. Currently supported objects are matrices, data
frames, spatial objects from the \pkg{sp} package
(\code{SpatialPoints}, \code{SpatialPointsDataFrame}, \code{Polygon},
\code{Polygons}, \code{SpatialPolygons}, \code{SpatialPolygonsDataFrame},
\code{Line}, \code{Lines}, \code{SpatialLines}, and
\code{SpatialLinesDataFrame}), and
spatial data frames from the \pkg{sf} package.}

\item{...}{arguments to pass to \link[leaflet]{addControl}}

\item{labelStyle}{character string of style argument for HTML text}

\item{opacity}{opacity of the legend items}
}
\value{
an object from \link[leaflet]{addControl}
}
\description{
Functions for more control over the styling of 'leaflet' legends.
The 'leaflet'
map is passed through and the output is a 'leaflet' control so that
the legends are integrated with other functionality of the API. Style
the text of the labels, the symbols used, orientation of the legend items,
and sizing of all elements.
}
\examples{
library(leaflet)

data(quakes)

# Numeric Legend

numPal <- colorNumeric('viridis', quakes$depth)
leaflet() \%>\%
  addTiles() \%>\%
  addLegendNumeric(
    pal = numPal,
    values = quakes$depth,
    position = 'topright',
    title = 'addLegendNumeric (Horizontal)',
    orientation = 'horizontal',
    shape = 'rect',
    decreasing = FALSE,
    height = 20,
    width = 100
  ) \%>\%
  addLegendNumeric(
    pal = numPal,
    values = quakes$depth,
    position = 'topright',
    title = htmltools::tags$div('addLegendNumeric (Decreasing)',
    style = 'font-size: 24px; text-align: center; margin-bottom: 5px;'),
    orientation = 'vertical',
    shape = 'stadium',
    decreasing = TRUE,
    height = 100,
    width = 20
  ) \%>\%
  addLegend(pal = numPal, values = quakes$depth, title = 'addLegend')

# Quantile Legend
# defaults to adding quantile numeric break points

quantPal <- colorQuantile('viridis', quakes$mag, n = 5)
leaflet() \%>\%
  addTiles() \%>\%
  addCircleMarkers(data = quakes,
                   lat = ~lat,
                   lng = ~long,
                   color = ~quantPal(mag),
                   opacity = 1,
                   fillOpacity = 1
  ) \%>\%
  addLegendQuantile(pal = quantPal,
                    values = quakes$mag,
                    position = 'topright',
                    title = 'addLegendQuantile',
                    numberFormat = function(x) {prettyNum(x, big.mark = ',',
                    scientific = FALSE, digits = 2)},
                    shape = 'circle') \%>\%
  addLegendQuantile(pal = quantPal,
                    values = quakes$mag,
                    position = 'topright',
                    title = htmltools::tags$div('addLegendQuantile',
                                                htmltools::tags$br(),
                                                '(Omit Numbers)'),
                    numberFormat = NULL,
                    shape = 'circle') \%>\%
  addLegend(pal = quantPal, values = quakes$mag, title = 'addLegend')

# Factor Legend
# Style the title with html tags, several shapes are supported drawn with svg

quakes[['group']] <- sample(c('A', 'B', 'C'), nrow(quakes), replace = TRUE)
factorPal <- colorFactor('Dark2', quakes$group)
leaflet() \%>\%
  addTiles() \%>\%
  addCircleMarkers(
    data = quakes,
    lat = ~ lat,
    lng = ~ long,
    color = ~ factorPal(group),
    opacity = 1,
    fillOpacity = 1
  ) \%>\%
  addLegendFactor(
    pal = factorPal,
    title = htmltools::tags$div('addLegendFactor', style = 'font-size: 24px;
    color: red;'),
    values = quakes$group,
    position = 'topright',
    shape = 'triangle',
    width = 50,
    height = 50
  ) \%>\%
  addLegend(pal = factorPal,
            values = quakes$group,
            title = 'addLegend')

# Bin Legend
# Restyle the text of the labels, change the legend item orientation


# Group Layer Control
# Works with baseGroups and overlayGroups

}
