% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layergroupcollision.R
\name{LayerGroupCollision}
\alias{LayerGroupCollision}
\alias{addLayerGroupCollision}
\title{Add LayerGroup Collision Plugin}
\usage{
addLayerGroupCollision(
  map,
  group = NULL,
  className = NULL,
  html = NULL,
  margin = 5,
  data = getMapData(map)
)
}
\arguments{
\item{map}{the map to add awesome Markers to.}

\item{group}{the name of the group. It needs to be single string.}

\item{className}{A single CSS class or a vector of CSS classes.}

\item{html}{A single HTML string or a vector of HTML strings.}

\item{margin}{defines the margin between markers, in pixels}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
A leaflet map object with the LayerGroup Collision plugin added.
}
\description{
Integrates the LayerGroup Collision plugin into a Leaflet map,
which hides overlapping markers and only displays the first added marker in a
collision group. Markers must be static; dynamic changes, dragging, and
deletions are not supported.
The function transforms spatial data into GeoJSON format and uses `L.DivIcon`,
allowing you to pass HTML content and CSS classes to style the markers.
}
\examples{
library(leaflet)
library(sf)
library(leaflet.extras2)

df <- sf::st_as_sf(atlStorms2005)
df <- suppressWarnings(st_cast(df, "POINT"))
df$classes <- sample(x = 1:5, nrow(df), replace = TRUE)

leaflet() \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  leaflet::addLayersControl(overlayGroups = c("Labels")) \%>\%
  addPolylines(data = sf::st_as_sf(atlStorms2005), label = ~Name) \%>\%
  addLayerGroupCollision(
    data = df, margin = 40,
    html = ~ paste0(
      '<div style="width: max-content; background-color: #cbc0c04f" class="custom-html">',
      '<div class="title">', Name, "</div>",
      '<div class="subtitle">MaxWind: ', MaxWind, "</div>",
      "</div>"
    ),
    className = ~ paste0("my-label my-label-", classes),
    group = "Labels"
  )
}
\references{
\url{https://github.com/MazeMap/Leaflet.LayerGroup.Collision}
}
