% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antpath.R
\name{addAntpath}
\alias{addAntpath}
\title{Add Antpath Lines}
\usage{
addAntpath(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  stroke = TRUE,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  fill = FALSE,
  fillColor = color,
  fillOpacity = 0.2,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = antpathOptions(),
  highlightOptions = NULL,
  data = getMapData(map)
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{stroke}{whether to draw stroke along the path (e.g. the borders of
polygons or circles)}

\item{color}{stroke color}

\item{weight}{stroke width in pixels}

\item{opacity}{stroke opacity (or layer opacity for tile layers)}

\item{fill}{whether to fill the path with color (e.g. filling on polygons or
circles)}

\item{fillColor}{fill color}

\item{fillOpacity}{fill opacity}

\item{dashArray}{a string that defines the stroke
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray}{dash
pattern}}

\item{smoothFactor}{how much to simplify the polyline on each zoom level
(more means better performance and less accurate representation)}

\item{noClip}{whether to disable polyline clipping}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{options}{A named list of options. See \code{\link{antpathOptions}}}

\item{highlightOptions}{Options for highlighting the shape on mouse over.}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
A modified leaflet map, with an 'ant-path' animated polyline
}
\description{
Can be used almost exactly like \code{addPolylines} but instead of
\code{pathOptions} you can use \code{\link{antpathOptions}} to adapt the
Antpath behaviour. See
\href{https://github.com/rubenspgcavalcante/leaflet-ant-path}{leaflet-ant-path}
for further details.
}
\examples{
library(leaflet)
leaflet() \%>\%
  addAntpath(data = atlStorms2005)
}
\references{
\url{https://github.com/rubenspgcavalcante/leaflet-ant-path}
}
\seealso{
Other Antpath Functions: 
\code{\link{antpathOptions}()},
\code{\link{clearAntpath}()},
\code{\link{removeAntpath}()}
}
\concept{Antpath Functions}
