% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debug_exercise_checker.R
\name{debug_exercise_checker}
\alias{debug_exercise_checker}
\title{An Exercise Checker for Debugging}
\usage{
debug_exercise_checker(
  label,
  user_code,
  solution_code,
  check_code,
  envir_result,
  evaluate_result,
  envir_prep,
  last_value,
  engine,
  ...
)
}
\arguments{
\item{label}{Exercise label}

\item{user_code}{Submitted user code}

\item{solution_code}{The code in the \verb{*-solution} chunk}

\item{check_code}{The checking code that originates from the \verb{*-check} chunk,
the \verb{*-code-check} chunk, or the \verb{*-error-check} chunk.}

\item{evaluate_result}{The return value from \code{evaluate::evaluate()}, called
on \code{user_code}}

\item{envir_prep, envir_result}{The environment before running user code
(\code{envir_prep}) and the environment just after running the user's code
(\code{envir_result}).}

\item{last_value}{The last value after evaluating \code{user_code}}

\item{engine}{The engine of the exercise chunk}

\item{...}{Not used (future compatibility)}
}
\value{
Feedback for use in exercise debugging.
}
\description{
An exercise checker for debugging that renders all of the expected arguments
of the \code{exercise.checker} option into HTML. Additionally, this function is
used in testing  of \code{evaluate_exercise()}.
}
\keyword{internal}
