% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{one_time}
\alias{one_time}
\title{Wrap an expression that will be executed one time in an event handler}
\usage{
one_time(session, cond, expr, label = deparse(substitute(cond)))
}
\arguments{
\item{session}{A Shiny session object.}

\item{cond}{A condition that is used as a filter. The first time the
condition evaluates to true, \code{expr} will be evaluated; after that, \code{expr}
will not be evaluated again.}

\item{expr}{An expression that will be evaluated once, the first time that
\code{cond} is true.}

\item{label}{A unique identifier. This is used as an ID for the condition and
expression; if two calls to \code{one_time()} uses the same label, there will be
an ID collision and only one of them will execute. By default, \code{cond} is
deparsed and used as the label.}
}
\value{
The result of evaluating \code{expr} (\code{one_time()} is intended to be
called within an event handler).
}
\description{
This wraps an expression so that it will be executed one time for a tutorial,
based on some condition. The first time the condition is true, the expression
will be executed; after that, the expression will not be evaluated again.

The execution state is stored so that if the expression is executed, then the
user quits the tutorial and then returns to it, the expression will not be
executed a second time.

A common use for \code{one_time} is to execute an expression when a section is
viewed for the first time.
}
\examples{
\dontrun{
# This goes in a {r context="server-start"} chunk

# The expression with message() will be executed the first time the user
# sees the section with ID "section-exercise-with-hint".
event_register_handler("section_viewed",
  function(session, event, data) {
    one_time(
      session,
      data$sectionId == "section-exercise-with-hint",
      {
        message("Seeing ", data$sectionId, " for the first time.")
      }
    )
  }
)


}

}
