% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_numeric.R
\name{question_numeric}
\alias{question_numeric}
\title{Number question}
\usage{
question_numeric(
  text,
  ...,
  correct = "Correct!",
  incorrect = "Incorrect",
  try_again = incorrect,
  allow_retry = FALSE,
  value = NULL,
  min = NA,
  max = NA,
  step = NA,
  options = list(),
  tolerance = 1.5e-08
)
}
\arguments{
\item{text}{Question or option text}

\item{...}{Answers created with \code{\link[=answer]{answer()}} or \code{\link[=answer_fn]{answer_fn()}}, or extra
parameters passed onto \code{\link[=question]{question()}}.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to
"Incorrect") when \code{allow_retry} is \code{FALSE}.}

\item{try_again}{Text to print for an incorrect answer (defaults to
"Incorrect") when \code{allow_retry} is \code{TRUE}.}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{value}{Initial value.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{options}{Extra options to be stored in the question object. This is
useful when using custom question types. See \code{\link[sortable:question_rank]{sortable::question_rank()}}
for an example question implementation that uses the \code{options} parameter.}

\item{tolerance}{Submitted values within an absolute difference less than or
equal to \code{tolerance} will be considered equal to the answer value. Note
that this tolerance is for all \code{\link[=answer]{answer()}} values. For more specific answer
value grading, use \code{\link[=answer_fn]{answer_fn()}} to provide your own evaluation code.}
}
\value{
Returns a learnr question of type \code{"learnr_numeric"}.
}
\description{
Creates a tutorial question asking the student to submit a number.
}
\examples{
question_numeric(
  "What is pi rounded to 2 digits?",
  answer(3, message = "Don't forget to use the digits argument"),
  answer(3.1, message = "Too few digits"),
  answer(3.142, message = "Too many digits"),
  answer(3.14, correct = TRUE),
  allow_retry = TRUE,
  min = 3,
  max = 4,
  step = 0.01
)

question_numeric(
  "Can you think of an even number?",
  answer_fn(function(value) {
    if (value \%\% 2 == 0) {
      correct("even")
    } else if (value \%\% 2 == 1) {
      incorrect("odd")
    }
  }, label = "Is the number even?"),
  step = 1
)

}
\seealso{
Other Interactive Questions: 
\code{\link{question_checkbox}()},
\code{\link{question_radio}()},
\code{\link{question_text}()},
\code{\link{quiz}()}
}
\concept{Interactive Questions}
