% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{flefko2}
\alias{flefko2}
\title{Create Function-based Ahistorical Matrix Projection Model}
\usage{
flefko2(
  year = "all",
  patch = "all",
  stageframe,
  supplement = NULL,
  repmatrix = NULL,
  overwrite = NULL,
  data = NA,
  modelsuite = NA,
  surv_model = NA,
  obs_model = NA,
  size_model = NA,
  sizeb_model = NA,
  sizec_model = NA,
  repst_model = NA,
  fec_model = NA,
  jsurv_model = NA,
  jobs_model = NA,
  jsize_model = NA,
  jsizeb_model = NA,
  jsizec_model = NA,
  jrepst_model = NA,
  paramnames = NA,
  inda = NULL,
  indb = NULL,
  indc = NULL,
  surv_dev = 0,
  obs_dev = 0,
  size_dev = 0,
  sizeb_dev = 0,
  sizec_dev = 0,
  repst_dev = 0,
  fec_dev = 0,
  jsurv_dev = 0,
  jobs_dev = 0,
  jsize_dev = 0,
  jsizeb_dev = 0,
  jsizec_dev = 0,
  jrepst_dev = 0,
  density = NA,
  repmod = 1,
  yearcol = NA,
  patchcol = NA,
  year.as.random = FALSE,
  patch.as.random = FALSE,
  random.inda = FALSE,
  random.indb = FALSE,
  random.indc = FALSE,
  randomseed = NA,
  negfec = FALSE,
  reduce = FALSE,
  err_check = FALSE,
  exp_tol = 700,
  theta_tol = 1e+08
)
}
\arguments{
\item{year}{A variable corresponding to observation occasion, or a set of
such values, given in values associated with the year term used in linear
model development. Defaults to \code{"all"}, in which case matrices will be
estimated for all occasion times.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Defaults to \code{"all"}, but can also be set to specific
patch names.}

\item{stageframe}{A stageframe object that includes information on the size,
observation status, propagule status, immaturity status, and maturity status
of each ahistorical stage. Should also incorporate bin widths if size is
continuous.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function. Can be used in place of or in addition to an overwrite table (see 
\code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
below).}

\item{repmatrix}{An optional reproduction matrix. This matrix is composed
mostly of 0s, with non-zero entries acting as element identifiers and
multipliers for fecundity (with 1 equaling full fecundity). If left blank,
and no \code{supplement} is provided, then \code{flefko2()} will assume that
all stages marked as reproductive produce offspring at 1x that of estimated
fecundity, and that offspring production will yield the first stage noted as
propagule or immature.  To prevent this behavior, input just \code{0}, which
will result in fecundity being estimated only for transitions noted in
\code{supplement} above. Must be the dimensions of an ahistorical matrix.}

\item{overwrite}{An optional data frame developed with the
\code{\link{overwrite}()} function describing transitions to be overwritten
either with given values or with other estimated transitions. Note that this
function supplements overwrite data provided in \code{supplement}.}

\item{data}{The historical vertical demographic data frame used to estimate
vital rates (class \code{hfvdata}). The original data frame is required in
order to initialize times and patches properly.}

\item{modelsuite}{An optional \code{lefkoMod} object holding the vital rate
models. If given, then \code{surv_model}, \code{obs_model}, 
\code{size_model}, \code{sizeb_model}, \code{sizec_model},
\code{repst_model}, \code{fec_model}, \code{jsurv_model}, \code{jobs_model},
\code{jsize_model}, \code{jsizeb_model}, \code{jsizec_model},
\code{jrepst_model}, \code{paramnames}, \code{yearcol}, and \code{patchcol}
are not required. No models should include size or reproductive status in
occasion \emph{t}-1.}

\item{surv_model}{A linear model predicting survival probability. This can
be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. If given, then will overwrite any
survival probability model given in \code{modelsuite}. This model must have
been developed in a modeling exercise testing only the impacts of occasion 
\emph{t}.}

\item{obs_model}{A linear model predicting sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. If given, then
will overwrite any observation probability model given in \code{modelsuite}.
This model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{size_model}{A linear model predicting primary size. This can be a model
of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. If given, then will overwrite any
primary size model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{sizeb_model}{A linear model predicting secondary size. This can be a
modelvof class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. If given, then will overwrite any
secondary size model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{sizec_model}{A linear model predicting tertiary size. This can be a
modelvof class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. If given, then will overwrite any
tertiary size model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{repst_model}{A linear model predicting reproduction probability. This
can be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. If given, then will overwrite any
reproduction probability model given in \code{modelsuite}. This model must
have been developed in a modeling exercise testing only the impacts of
occasion \emph{t}.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. If given, then will overwrite any 
fecundity model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{jsurv_model}{A linear model predicting juvenile survival probability.
This can be a model of class \code{glm} or \code{glmer}, and requires a
predicted binomial variable under a logit link. If given, then will overwrite
any juvenile survival probability model given in \code{modelsuite}. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jobs_model}{A linear model predicting juvenile sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. If given, then
will overwrite any juvenile observation probability model given in 
\code{modelsuite}. This model must have been developed in a modeling exercise
testing only the impacts of occasion \emph{t}.}

\item{jsize_model}{A linear model predicting juvenile primary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. If given, then will
overwrite any juvenile primary size model given in \code{modelsuite}. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jsizeb_model}{A linear model predicting juvenile secondary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. If given, then will
overwrite any juvenile secondary size model given in \code{modelsuite}. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jsizec_model}{A linear model predicting juvenile tertiary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. If given, then will
overwrite any juvenile tertiary size model given in \code{modelsuite}. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jrepst_model}{A linear model predicting reproduction probability of a 
mature individual that was immature in the previous year. This can be a model 
of class \code{glm} or \code{glmer}, and requires a predicted binomial
variable under a logit link. If given, then will overwrite any reproduction
probability model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{paramnames}{A dataframe with three columns, the first describing all
terms used in linear modeling, the second (must be called \code{mainparams}),
showing the general model terms that will be used in matrix creation (users
should use \code{\link{modelsearch}()} at least once to see the proper
names to be used in this column), and the third showing the equivalent terms
used in modeling (must be named \code{modelparams}). Only required if
\code{modelsuite} is not supplied.}

\item{inda}{Can be a single value to use for individual covariate \code{a}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in option \code{year}. Defaults to \code{NULL}.}

\item{indb}{Can be a single value to use for individual covariate \code{b}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in option \code{year}. Defaults to \code{NULL}.}

\item{indc}{Can be a single value to use for individual covariate \code{c}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in option \code{year}. Defaults to \code{NULL}.}

\item{surv_dev}{A numeric value to be added to the y-intercept in the linear
model for survival probability.}

\item{obs_dev}{A numeric value to be added to the y-intercept in the linear
model for observation probability.}

\item{size_dev}{A numeric value to be added to the y-intercept in the linear
model for primary size.}

\item{sizeb_dev}{A numeric value to be added to the y-intercept in the linear
model for secondary size.}

\item{sizec_dev}{A numeric value to be added to the y-intercept in the linear
model for tertiary size.}

\item{repst_dev}{A numeric value to be added to the y-intercept in the linear
model for probability of reproduction.}

\item{fec_dev}{A numeric value to be added to the y-intercept in the linear
model for fecundity.}

\item{jsurv_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile survival probability.}

\item{jobs_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile observation probability.}

\item{jsize_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile primary size.}

\item{jsizeb_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile secondary size.}

\item{jsizec_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile tertiary size.}

\item{jrepst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile reproduction probability.}

\item{density}{A numeric value indicating density value to use to propagate
matrices. Only needed if density is an explanatory term used in linear
models. Defaults to \code{NA}.}

\item{repmod}{A scalar multiplier of fecundity. Defaults to \code{1}.}

\item{yearcol}{The variable name or column number corresponding to year in
occasion \emph{t} in the dataset. Not needed if a \code{modelsuite} is
supplied.}

\item{patchcol}{The variable name or column number corresponding to patch in
the dataset. Not needed if a \code{modelsuite} is supplied.}

\item{year.as.random}{A logical term indicating whether coefficients for
missing occasions within vital rate models should be estimated as random
intercepts. Defaults to \code{FALSE}, in which case missing monitoring
occasion coefficients are set to \code{0}.}

\item{patch.as.random}{A logical term indicating whether coefficients for
missing patches within vital rate models should be estimated as random
intercepts. Defaults to \code{FALSE}, in which case missing patch
coefficients are set to \code{0}.}

\item{random.inda}{A logical value denoting whether to treat individual
covariate \code{a} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indb}{A logical value denoting whether to treat individual
covariate \code{b} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indc}{A logical value denoting whether to treat individual
covariate \code{c} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{randomseed}{A numeric value used as a seed to generate random estimates
for missing occasion and patch coefficients, if either \code{year.as.random}
or \code{patch.as.random} is set to \code{TRUE}. Defaults to
\code{\link{set.seed}()} default.}

\item{negfec}{A logical value denoting whether fecundity values estimated to
be negative should be reset to \code{0}. Defaults to \code{FALSE}.}

\item{reduce}{A logical value denoting whether to remove ahistorical stages
associated solely with 0 transitions. These are only removed in cases where
the associated row and column sums in ALL matrices estimated equal 0.
Defaults to \code{FALSE}.}

\item{err_check}{A logical value indicating whether to append matrices of
vital rate probabilities associated with each matrix to the \code{lefkoMat}
object generated. These matrices are developed internally and can be used for
error checking. Defaults to \code{FALSE}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}
}
\value{
If all inputs are properly formatted, then this function will return
an object of class \code{lefkoMat}, which is a list that holds the matrix
projection model and all of its metadata. Its structure is a list with the
following elements:

\item{A}{A list of full projection matrices in order of sorted patches and
occasion times. All matrices output in R's \code{matrix} class.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in R's \code{matrix} class.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in R's \code{matrix} class.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs. Set to \code{NA} for ahistorical
matrices.}
\item{agestages}{A data frame showing age-stage pairs. In this function, it
is set to \code{NA}. Only used in output to function \code{aflefko2}().}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the population, patch, and year of each
matrix in order. In \code{flefko2()}, only one population may be analyzed at
once, and so \code{pop = NA}.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} matrices, and the number of matrices.}
\item{modelqc}{This is the \code{qc} portion of the modelsuite input.}
\item{prob_out}{An optional element only added if \code{err_check = TRUE}.
This is a list of vital rate probability matrices, with 6 columns in the
order of survival, observation probability, reproduction probability, primary
size transition probability, secondary size transition probability, and
tertiary size transition probability.}
}
\description{
Function \code{flefko2()} returns ahistorical MPMs corresponding to the
patches and occasion times given, including the associated component
transition and fecundity matrices, a data frame detailing the characteristics
of the ahistorical stages used, and a data frame characterizing the patch and
occasion time combinations corresponding to these matrices.
}
\section{Notes}{

Unlike \code{\link{rlefko2}()} and \code{\link{rlefko3}()}, this function
does not currently distinguish populations.

This function will yield incorrect estimates if the models utilized
incorporate state in occasion \emph{t}-1. Only use models developed testing
for ahistorical effects.

The default behavior of this function is to estimate fecundity with regards
to transitions specified via associated fecundity multipliers in either
\code{supplement} or \code{repmatrix}. If both of these fields are left
empty, then fecundity will be estimated at full for all transitions leading
from reproductive stages to immature and propagule stages. However, if a
\code{supplement} is provided and a \code{repmatrix} is not, or if
\code{repmatrix} is set to \code{0}, then only fecundity transitions noted in
the \code{supplement} will be set to non-zero values. To use the default
behavior of setting all reproductive stages to reproduce at full fecundity
into immature and propagule stages, but also incorporate given or proxy
survival transitions, input those given and proxy transitions through the
\code{overwrite} option.

The reproduction matrix (field \code{repmatrix}) may only be supplied as
ahistorical. If provided as historical, then \code{flefko2()} will fail and
produce an error.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations, but without discriminating between those
patches or subpopulations. Should the aim of analysis be a general MPM that
does not distinguish these patches or subpopulations, the \code{patchcol}
variable should be set to \code{NA}, which is the default.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1 and \emph{t}. Rearranging the order will
lead to erroneous calculations, and may lead to fatal errors.

Care should be taken to match the random status of year and patch to the
states of those variables within the modelsuite. If they do not match, then
they will be treated as zeroes in vital rate estimation.

Using the \code{err_check} option will produce a matrix of 6 columns, each
characterizing a different vital rate. The product of each row yields an
element in the associated \code{$U} matrix. The number and order of elements
in each column of this matrix matches the associated matrix in column vector
format. Use of this option is generally for the purposes of debugging code.
}

\examples{
\donttest{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr", 
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, 
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln,
  stagesize = "sizea", censorcol = "Missing1988", censorkeep = NA,
  NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln2 <- modelsearch(lathvertln, historical = FALSE, 
  approach = "mixed", suite = "main",
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson",
  indiv = "individ", patch = "patchid", year = "year2",
  year.as.random = TRUE, patch.as.random = TRUE, show.model.tables = TRUE,
  quiet = TRUE)

# Here we use supplemental to provide overwrite and reproductive info
lathsupp2 <- supplemental(stage3 = c("Sd", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "rep", "rep"),
  givenrate = c(0.345, 0.054, NA, NA),
  multiplier = c(NA, NA, 0.345, 0.054),
  type = c(1, 1, 3, 3), stageframe = lathframeln, historical = FALSE)

lathmat2ln <- flefko2(year = "all", patch = "all", stageframe = lathframeln, 
  modelsuite = lathmodelsln2, data = lathvertln, supplement = lathsupp2,
  patchcol = "patchid", yearcol = "year2", year.as.random = FALSE,
  patch.as.random = FALSE, reduce = FALSE)

summary(lathmat2ln)

#Cypripedium example using three size metrics for classification
rm(list=ls(all=TRUE))

data(cypdata)
sizevector.f <- c(0, 0, 0, 0, 0, 0, seq(1, 12, by = 1), seq(0, 9, by = 1),
  seq(0, 8, by = 1), seq(0, 7, by = 1), seq(0, 6, by = 1), seq(0, 5, by = 1),
  seq(0, 4, by = 1), seq(0, 3, by = 1), 0, 1, 2, 0, 1, 0, 
  0, 0, 1, 0)
sizebvector.f <- c(0, 0, 0, 0, 0, 0, rep(0, 12), rep(1, 10), rep(2, 9),
  rep(3, 8), rep(4, 7), rep(5, 6), rep(6, 5), rep(7, 4), rep(8, 3), 9, 9, 10, 
  0, 1, 1, 2)
sizecvector.f <- c(0, 0, 0, 0, 0, 0, rep(0, 12), rep(0, 10), rep(0, 9),
  rep(0, 8), rep(0, 7), rep(0, 6), rep(0, 5), rep(0, 4), 0, 0, 0, 0, 0, 0, 
  1, 1, 1, 1)
stagevector.f <- c("DS", "P1", "P2", "P3", "Sdl", "Dorm", "V1 I0 D0",
  "V2 I0 D0", "V3 I0 D0", "V4 I0 D0", "V5 I0 D0", "V6 I0 D0", "V7 I0 D0",
  "V8 I0 D0", "V9 I0 D0", "V10 I0 D0", "V11 I0 D0", "V12 I0 D0", "V0 I1 D0",
  "V1 I1 D0", "V2 I1 D0", "V3 I1 D0", "V4 I1 D0", "V5 I1 D0", "V6 I1 D0",
  "V7 I1 D0", "V8 I1 D0", "V9 I1 D0", "V0 I2 D0", "V1 I2 D0", "V2 I2 D0",
  "V3 I2 D0", "V4 I2 D0", "V5 I2 D0", "V6 I2 D0", "V7 I2 D0", "V8 I2 D0",
  "V0 I3 D0", "V1 I3 D0", "V2 I3 D0", "V3 I3 D0", "V4 I3 D0", "V5 I3 D0",
  "V6 I3 D0", "V7 I3 D0", "V0 I4 D0", "V1 I4 D0", "V2 I4 D0", "V3 I4 D0",
  "V4 I4 D0", "V5 I4 D0", "V6 I4 D0", "V0 I5 D0", "V1 I5 D0", "V2 I5 D0",
  "V3 I5 D0", "V4 I5 D0", "V5 I5 D0", "V0 I6 D0", "V1 I6 D0", "V2 I6 D0",
  "V3 I6 D0", "V4 I6 D0", "V0 I7 D0", "V1 I7 D0", "V2 I7 D0", "V3 I7 D0",
  "V0 I8 D0", "V1 I8 D0", "V2 I8 D0", "V0 I9 D0", "V1 I9 D0", "V0 I10 D0",
  "V0 I0 D1", "V0 I1 D1", "V1 I1 D1", "V0 I2 D1")
repvector.f <- c(0, 0, 0, 0, 0, rep(0, 13), rep(1, 59))
obsvector.f <- c(0, 0, 0, 0, 0, 0, rep(1, 71))
matvector.f <- c(0, 0, 0, 0, 0, rep(1, 72))
immvector.f <- c(0, 1, 1, 1, 1, rep(0, 72))
propvector.f <- c(1, rep(0, 76))
indataset.f <- c(0, 0, 0, 0, 0, rep(1, 72))
binvec.f <- c(0, 0, 0, 0, 0, rep(0.5, 72))
binbvec.f <- c(0, 0, 0, 0, 0, rep(0.5, 72))
bincvec.f <- c(0, 0, 0, 0, 0, rep(0.5, 72))

vertframe.f <- sf_create(sizes = sizevector.f, sizesb = sizebvector.f,
  sizesc = sizecvector.f, stagenames = stagevector.f, repstatus = repvector.f,
  obsstatus = obsvector.f, propstatus = propvector.f, immstatus = immvector.f,
  matstatus = matvector.f, indataset = indataset.f, binhalfwidth = binvec.f,
  binhalfwidthb = binbvec.f, binhalfwidthc = bincvec.f)

vert.data.f <- verticalize3(cypdata, noyears = 6, firstyear = 2004,
  individcol = "plantid", blocksize = 4, sizeacol = "Veg.04",
  sizebcol = "Inf.04", sizeccol = "Inf2.04", repstracol = "Inf.04",
  repstrbcol = "Inf2.04", fecacol = "Pod.04", censorcol = "censor",
  censorkeep = 1, censorRepeat = FALSE, stageassign = vertframe.f,
  stagesize = "sizeabc", NAas0 = TRUE, censor = FALSE)

vertmodels2f <- modelsearch(vert.data.f, historical = FALSE, suite = "main", 
  sizeb = c("sizeb3", "sizeb2", "sizeb1"), sizec = c("sizec3", "sizec2", "sizec1"),
  approach = "glm", vitalrates = c("surv", "obs", "size", "repst", "fec"),
  sizedist = "negbin", sizebdist = "poisson", sizecdist = "poisson",
  fecdist = "poisson", patch.as.random = TRUE, year.as.random = TRUE)

vertsupp2f <- supplemental(stage3 = c("DS", "P1", "P2", "P3", "Sdl", "Sdl",
    "Dorm", "V1 I0 D0", "V2 I0 D0", "V3 I0 D0", "DS", "P1"),
  stage2 = c("DS", "DS", "P1", "P2", "P3", "Sdl", "Sdl", "Sdl", "Sdl", "Sdl",
    "rep", "rep"), 
  eststage3 = c(NA, NA, NA, NA, NA, NA, "Dorm", "V1 I0 D0", "V2 I0 D0",
    "V3 I0 D0", NA, NA), 
  eststage2 = c(NA, NA, NA, NA, NA, NA, "V1 I0 D0", "V1 I0 D0", "V1 I0 D0",
    "V1 I0 D0", NA, NA), 
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, 0.40, NA, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 0.5 * 5000, 0.5 * 5000),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3), stageframe = vertframe.f,
  historical = FALSE)

vert.mats.f2 <- flefko2(stageframe = vertframe.f, supplement = vertsupp2f, 
  data = vert.data.f, modelsuite = vertmodels2f)
summary(vert.mats.f2)
}

}
