% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-man.R
\name{meeting_schedule-db}
\alias{meeting_schedule-db}
\title{Meeting Schedule Database}
\arguments{
\item{member_id}{the id of a LegCo member, or a vector of ids. If
\code{NULL}, returns results of all LegCo members. Defaults to \code{NULL}.}

\item{term_id}{the id of a term, or a vector of ids. If \code{NULL}, returns
results of all terms. Defaults to \code{NULL}.}

\item{session_id}{the id of a session, or a vector of ids. If \code{NULL},
returns result of all sessions. Defaults to \code{NULL}.}

\item{slot_id}{the id of a meeting slot, or a vector of ids. If \code{NULL},
returns all meetings. Defaults to \code{NULL}.}

\item{meet_id}{the id of a meeting, or a vector of ids. If \code{NULL},
returns all meetings. Useful for matching meeting with records from the
Attendance Database. Defaults to \code{NULL}.}

\item{committee_id}{the id of a committee, or a vector of ids. If
\code{NULL}, returns results of all committees. Defaults to \code{NULL}.}

\item{code}{the code of a committee, or a vector of ids. If \code{NULL},
returns all committees. Defaults to \code{NULL}.}

\item{type}{the type of meeting. If \code{"open"}, returns open meetings. If
\code{"closed"}, returns closed meetings. If \code{"all"}, returns all
meetings. Defaults to \code{"all"}.}

\item{post}{the post of a member in the committee, or a vector of posts.
\code{"President"}, \code{"Chairman"}, \code{"Deputy Chairman"},
\code{"Member"} and \code{"Convenor"} return members of the respective
post. If \code{NULL}, returns members of all posts. Defaults to
\code{NULL}.}

\item{date}{only fetch the result in which the specified date falls within.
Accepts character values in \code{"YYYY-MM-DD"} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}. Defaults
to \code{NULL}.}

\item{extra_param}{additional query parameters defined in LegCo API. Must
begin with \code{"&"}.}

\item{n}{the number of record to fetch. Defaults to \code{1000}.}

\item{count}{logical: Whether to return only the total count of records that
matches the parameter(s) instead of the result. Defaults to \code{FALSE}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
This database contains the information of LegCo committees, namely the name
of all LegCo committees established since the fifth term and their
corresponding member lists and meeting schedule.
}
\section{Functions}{
 Functions of the Meeting Schedule Database: \itemize{
  \item \code{\link{term}}: LegCo terms \item \code{\link{session}}: LegCo
  sessions \item \code{\link{committee}}: LegCo committees \item
  \code{\link{membership}}: Membership of LegCo committees \item
  \code{\link{member}}: LegCo members \item \code{\link{member_term}}: Terms
  served by LegCo members \item \code{\link{meeting}}: Meetings of LegCo
  committees \item \code{\link{meeting_committee}}: Committees of LegCo
  meetings }
}

\seealso{
LegCo API documentation for the Meeting Schedule database:
  \url{https://www.legco.gov.hk/odata/english/attendance-db.html}
}
