% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{param_defaults}
\alias{param_defaults}
\alias{param_new}
\title{Default parameters}
\usage{
param_defaults(values)

param_new(values)
}
\arguments{
\item{values}{optional named numeric \code{vector}, values will override any
defaults}
}
\value{
named \code{list}
}
\description{
Returns the default Lemna model parameters as reported by Klein et al. (2021).
}
\details{
\subsection{Model parameters}{
\subsection{Growth model}{
\itemize{
\item \code{k_photo_fixed}, Model switch for unlimited growth conditions (TRUE/FALSE)
\item \code{k_photo_max}, Maximum photosynthesis rate (d-1)
\item \code{k_loss}, Reference loss rate (d-1)
\item \code{BM_threshold}, Lower biomass abundance threshold (g dw m-2)
\item \code{BM_min}, Reservoir for biomass recovery (g dw m-2)
}
}

\subsection{Temperature response of photosynthesis}{
\itemize{
\item \code{T_opt}, Optimum growth temperature (deg C)
\item \code{T_min}, Minimum growth temperature (deg C)
\item \code{T_max}, Maximum growth temperature (deg C)
}
}

\subsection{Temperature response of biomass loss rate}{
\itemize{
\item \code{Q10}, Temperature coefficient (-)
\item \code{T_ref}, Reference temperature for response=1 (°C)
}
}

\subsection{Irradiance reponse of photosynthesis}{
\itemize{
\item \code{alpha}, Slope of irradiance response (m2 d kJ-1)
\item \code{beta}, Intercept of irradiance response (-)
}
}

\subsection{Nutrient response of photosynthesis}{
\itemize{
\item \code{N_50}, Half-saturation constant of Nitrogen (mg N L-1)
\item \code{P_50}, Half-saturation constant of Phosphorus (mg P L-1)
}
}

\subsection{Density dependence of photosynthesis}{
\itemize{
\item \code{BM_L}, Carrying capacity (g dw m-2)
}
}

\subsection{Concentration response (Toxicodynamics)}{
\itemize{
\item \code{EC50_int}, Internal concentration resulting in 50\% effect (mass per volume)
\item \code{E_max}, Maximum inhibition (-)
\item \code{b}, Slope parameter (-)
}
}

\subsection{Internal concentration (Toxicokinetics)}{
\itemize{
\item \code{P}, Permeability (cm d-1)
\item \code{r_A_DW}, Area per dry-weight ratio (cm2 g-1)
\item \code{r_FW_DW}, Fresh weight per dry weight ratio (-)
\item \code{r_FW_V}, Fresh weight density (g cm-3)
\item \code{r_DW_FN} Dry weight per frond ratio (g dw)
\item \code{K_pw}, Partitioning coefficient plant:water (-)
\item \code{k_met}, Metabolisation rate (d-1)
}
}

}
}
\section{Functions}{
\itemize{
\item \code{param_new}: A parameter set without default values
}}

\examples{
# Returns default model parameters, some parameters are not defined (NA)
param_defaults()

# Overwrite one of the default parameters
param_defaults(list(k_photo_max = 0.42))

# Provide values for substance specific TKTD parameters
param_defaults(list(
  EC50_int = 23, # 50\% effect level (mass per volume)
  b = 1,         # slope parameter (-)
  P = 0.42       # permeability (cm d-1)
))

# Returns a list of required model parameters with all values set to NA
param_new()
}
\references{
Klein J., Cedergreen N., Heine S., Reichenberger S., Rendal C.,
Schmitt W., Hommen U., 2021: Refined description of the \emph{Lemna} TKTD growth model
based on \emph{Schmitt et al.} (2013) – equation system and default parameters.
Report of the working group \emph{Lemna} of the SETAC Europe Interest Group Effect
Modeling. Version 1, uploaded on 22. Sept. 2021.
\url{https://www.setac.org/group/SEIGEffectModeling}
}
