% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvRegularizeSmoothSEMInterface.R
\name{cvSmoothLasso}
\alias{cvSmoothLasso}
\title{cvSmoothLasso}
\usage{
cvSmoothLasso(
  lavaanModel,
  regularized,
  lambdas,
  epsilon,
  k = 5,
  standardize = FALSE,
  returnSubsetParameters = FALSE,
  modifyModel = lessSEM::modifyModel(),
  control = lessSEM::controlBFGS()
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{regularized}{vector with names of parameters which are to be regularized.
If you are unsure what these parameters are called, use
getLavaanParameters(model) with your lavaan model object}

\item{lambdas}{numeric vector: values for the tuning parameter lambda}

\item{epsilon}{epsilon > 0; controls the smoothness of the approximation. Larger values = smoother}

\item{k}{the number of cross-validation folds. Alternatively, you can pass
a matrix with booleans (TRUE, FALSE) which indicates for each person which subset
it belongs to. See ?lessSEM::createSubsets for an example of how this matrix should look like.}

\item{standardize}{Standardizing your data prior to the analysis can undermine the cross-
validation. Set standardize=TRUE to automatically standardize the data.}

\item{returnSubsetParameters}{set to TRUE to return the parameters for each training set}

\item{modifyModel}{used to modify the lavaanModel. See ?modifyModel.}

\item{control}{used to control the optimizer. This element is generated with
the controlBFGS function. See ?controlBFGS for more details.}
}
\value{
model of class cvRegularizedSEM
}
\description{
Implements cross-validated smooth lasso regularization for structural equation models.
The penalty function is given by:
\deqn{p( x_j) = \lambda \sqrt{(x_j + \epsilon)^2}}
}
\details{
Identical to \pkg{regsem}, models are specified using \pkg{lavaan}. Currently,
most standard SEM are supported. \pkg{lessSEM} also provides full information
maximum likelihood for missing data. To use this functionality,
fit your \pkg{lavaan} model with the argument \code{sem(..., missing = 'ml')}.
\pkg{lessSEM} will then automatically switch to full information maximum likelihood
as well.

Lasso regularization:
\itemize{
\item Tibshirani, R. (1996). Regression shrinkage and selection via the lasso. Journal of the Royal Statistical
Society. Series B (Methodological), 58(1), 267–288.
}

Regularized SEM
\itemize{
\item Huang, P.-H., Chen, H., & Weng, L.-J. (2017). A Penalized Likelihood Method for Structural Equation Modeling. Psychometrika, 82(2), 329–354. https://doi.org/10.1007/s11336-017-9566-9
\item Jacobucci, R., Grimm, K. J., & McArdle, J. J. (2016). Regularized Structural Equation Modeling. Structural
Equation Modeling: A Multidisciplinary Journal, 23(4), 555–566. https://doi.org/10.1080/10705511.2016.1154793
}
}
\examples{
library(lessSEM)

# Identical to regsem, lessSEM builds on the lavaan
# package for model specification. The first step
# therefore is to implement the model in lavaan.

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 + 
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 + 
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)

# Regularization:

lsem <- cvSmoothLasso(
  # pass the fitted lavaan model
  lavaanModel = lavaanModel,
  # names of the regularized parameters:
  regularized = paste0("l", 6:15),
  lambdas = seq(0,1,.1),
  k = 5, # number of cross-validation folds
  epsilon = 1e-8,
  standardize = TRUE) # automatic standardization

# use the plot-function to plot the cross-validation fit:
plot(lsem)

# the coefficients can be accessed with:
coef(lsem)

# elements of lsem can be accessed with the @ operator:
lsem@parameters

# The best parameters can also be extracted with:
coef(lsem)
}
