% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx.R
\name{ctx}
\alias{ctx}
\alias{ctx3}
\alias{ctx3bilat}
\alias{ctx5}
\alias{ctx5bilat}
\alias{as.ctx3}
\alias{as.ctx3.ctx3}
\alias{as.ctx3.ctx3bilat}
\alias{as.ctx3.ctx5}
\alias{as.ctx3.ctx5bilat}
\alias{as.ctx3.default}
\alias{as.ctx3bilat}
\alias{as.ctx3bilat.ctx3bilat}
\alias{as.ctx3bilat.ctx3}
\alias{as.ctx3bilat.ctx5}
\alias{as.ctx3bilat.ctx5bilat}
\alias{as.ctx3bilat.default}
\alias{as.ctx5}
\alias{as.ctx5.ctx5}
\alias{as.ctx5.ctx3}
\alias{as.ctx5.ctx3bilat}
\alias{as.ctx5.ctx5bilat}
\alias{as.ctx5.default}
\alias{as.ctx5bilat}
\alias{as.ctx5bilat.ctx5bilat}
\alias{as.ctx5bilat.ctx3}
\alias{as.ctx5bilat.ctx3bilat}
\alias{as.ctx5bilat.ctx5}
\alias{as.ctx5bilat.default}
\alias{is.ctx3}
\alias{is.ctx3bilat}
\alias{is.ctx5}
\alias{is.ctx5bilat}
\title{Context for linguistic expressions}
\usage{
ctx3(
  low = 0,
  center = low + (high - low) * relCenter,
  high = 1,
  relCenter = 0.5
)

ctx3bilat(
  negMax = -1,
  negCenter = origin + (negMax - origin) * relCenter,
  origin = 0,
  center = origin + (max - origin) * relCenter,
  max = 1,
  relCenter = 0.5
)

ctx5(
  low = 0,
  lowerCenter = mean(c(low, center)),
  center = low + (high - low) * relCenter,
  upperCenter = mean(c(center, high)),
  high = 1,
  relCenter = 0.5
)

ctx5bilat(
  negMax = -1,
  negUpperCenter = mean(c(negCenter, negMax)),
  negCenter = origin + (negMax - origin) * relCenter,
  negLowerCenter = mean(c(origin, negCenter)),
  origin = 0,
  lowerCenter = mean(c(origin, center)),
  center = origin + (max - origin) * relCenter,
  upperCenter = mean(c(center, max)),
  max = 1,
  relCenter = 0.5
)

as.ctx3(x)

\method{as.ctx3}{ctx3}(x)

\method{as.ctx3}{ctx3bilat}(x)

\method{as.ctx3}{ctx5}(x)

\method{as.ctx3}{ctx5bilat}(x)

\method{as.ctx3}{default}(x)

as.ctx3bilat(x)

\method{as.ctx3bilat}{ctx3bilat}(x)

\method{as.ctx3bilat}{ctx3}(x)

\method{as.ctx3bilat}{ctx5}(x)

\method{as.ctx3bilat}{ctx5bilat}(x)

\method{as.ctx3bilat}{default}(x)

as.ctx5(x)

\method{as.ctx5}{ctx5}(x)

\method{as.ctx5}{ctx3}(x)

\method{as.ctx5}{ctx3bilat}(x)

\method{as.ctx5}{ctx5bilat}(x)

\method{as.ctx5}{default}(x)

as.ctx5bilat(x)

\method{as.ctx5bilat}{ctx5bilat}(x)

\method{as.ctx5bilat}{ctx3}(x)

\method{as.ctx5bilat}{ctx3bilat}(x)

\method{as.ctx5bilat}{ctx5}(x)

\method{as.ctx5bilat}{default}(x)

is.ctx3(x)

is.ctx3bilat(x)

is.ctx5(x)

is.ctx5bilat(x)
}
\arguments{
\item{low}{Lowest value of an unilateral context.}

\item{center}{A positive middle value of a bilateral context, or simply a
middle value of an unilateral context.}

\item{high}{Highest value of an unilateral context.}

\item{relCenter}{A relative quantity used to compute the \code{negCenter}
and/or \code{center}, if they are not specified explicitly. The sensible
value is 0.5 for context symmetric around center, or 0.42 as proposed by
Novak.}

\item{negMax}{Lowest negative value of a bilateral context.}

\item{negCenter}{A negative middle value.}

\item{origin}{Origin, i.e. the initial point of the bilateral context. It is
typically a value of zero.}

\item{max}{Highest value of a bilateral context.}

\item{lowerCenter}{A typical positive value between origin and center.}

\item{upperCenter}{A typical positive value between center and maximum.}

\item{negUpperCenter}{A typical negative value between \code{negMax} and
\code{negCenter}.}

\item{negLowerCenter}{A typical negative value between \code{negCenter} and
\code{negOrigin}.}

\item{x}{A value to be examined or converted. For \verb{as.ctx*}, it can be
an instance of any \verb{ctx*} class or a numeric vector of size equal to
the number of points required for the given context type.}
}
\value{
\verb{ctx*} and \verb{as.ctx*} return an instance of the appropriate
class. \verb{is.ctx*} returns \code{TRUE} or \code{FALSE}.
}
\description{
A context describes a range of allowed values for a data column.
}
\details{
A context describes a range of allowed values for a data column. For that,
only the borders of the interval, i.e. minimum and maximum, are usually
needed, but we use contexts to hold more additional information that is
crucial for the construction of linguistic expressions.

Currently, four different contexts are supported that determine the types of
possible linguistic expressions, as constructed with \code{\link[=lingexpr]{lingexpr()}}.
Unilateral or bilateral context is allowed in the variants of trichotomy or
pentachotomy. Trichotomy distinguishes three points in the interval: the
lowest value, highest value, and center. Pentachotomy adds lower center and
upper center to them. As opposite to unilateral, the bilateral context
handles explicitly the negative values. That is, bilateral context expects
some middle point, the origin (usually 0), around which the positive and
negative values are placed.

Concretely, the type of the context determines the allowed atomic
expressions as follows:
\itemize{
\item \code{ctx3}: trichotomy (low, center, high) enables atomic expressions:
small, medium, big;
\item \code{ctx5}: pentachotomy (low, lowerCenter, center, upperCenter, high) enables
atomic expressions: small, lower medium, medium, upper medium, big;
\item \code{ctx3bilat}: bilateral trichotomy (negMax, negCenter, origin, center, max)
enables atomic expressions: negative big, negative medium, negative small,
zero, small, medium, big;
\item \code{ctx5bilat}: bilateral pentachotomy (negMax, negCenter, origin, center,
max) enables atomic expressions: negative big, negative medium, negative
small, zero, small, medium, big.
}

The \verb{as.ctx*} functions return instance of the appropriate class. The
functions perform the conversion so that missing points of the new context
are computed from the old context that is being transformed. In the
subsequent table, rows represent compatible values of different context
types:

\tabular{llll}{
ctx3   \tab ctx5        \tab ctx3bilat \tab ctx5bilat      \cr
\tab             \tab negMax    \tab negMax         \cr
\tab             \tab           \tab negUpperCenter \cr
\tab             \tab negCenter \tab negCenter      \cr
\tab             \tab           \tab negLowerCenter \cr
low    \tab low         \tab origin    \tab origin         \cr
\tab lowerCenter \tab           \tab lowerCenter    \cr
center \tab center      \tab center    \tab center \cr
\tab upperCenter \tab           \tab upperCenter \cr
high   \tab high        \tab max       \tab max
}

The \verb{as.ctx*} conversion is performed by replacing values by rows, as
indicated in the table above.  When converting from a context with less
points to a context with more points (e.g. from unilateral to bilateral, or
from trichotomy to pentachotomy), missing points are computed as follows:
\itemize{
\item \code{center} is computed as a mean of \code{origin} (or \code{low}) and \code{max} (or \code{high}).
\item \code{lowerCenter} is computed as a mean of \code{origin} (or \code{low}) and \code{center}.
\item \code{upperCenter} is computed as a mean of \code{mas} (or \code{high}) and \code{center}.
\item negative points (such as \code{negMax}, \code{negCenter} etc.) are computed
symmetrically around \code{origin} to the corresponding positive points.
}

The code \verb{as.ctx*} functions allow the parameter to be also a numeric
vector of size equal to the number of points required for the given context
type, i.e. 3 (\code{ctx3}), 5 (\code{ctx3bilat}, \code{ctx5}), or 9 (\code{ctx5bilat}).
}
\examples{
    ctx3(low=0, high=10)
    as.ctx3bilat(ctx3(low=0, high=10))
}
\seealso{
\code{\link[=minmax]{minmax()}}, \code{\link[=lingexpr]{lingexpr()}}, \code{\link[=horizon]{horizon()}}, \code{\link[=hedge]{hedge()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
