% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAplot_DE_fn.R
\name{MAplot_DE_fn}
\alias{MAplot_DE_fn}
\title{Find out the Up and Down regulated proteins from MA plot}
\usage{
MAplot_DE_fn(top_table, x1 = NULL, x2 = NULL, p = NULL)
}
\arguments{
\item{top_table}{Top table information}

\item{x1}{Cut-off limit for down-regulated proteins}

\item{x2}{Cut-off limit for up-regulated proteins}

\item{p}{Cut-off limit for p-values}
}
\value{
`Result` Top table along with up, down, significant and non-significant protein information.

`MA plot` Interacive MA plot with the details of up and down regulated proteins

`Up-regulated` Up-regulated protein information

`Down-regulated` Down-regulated protein information

`Non-significant` Non-significant protein information
}
\description{
MA plot is used for visualizing the differentially expressed proteins by plotting the log mean intensity data in x axis and log fold change values in y axis.

This function can be used for visualizing the up regulated, down regulated, and non-significant proteins along with their information.
}
\examples{
result <- MAplot_DE_fn(yeast_top_table, -1, 1, 0.05)
result$`MA Plot`
result$`Result`
result$`Up-regulated`
result$`Down-regulated`
result$`Non-significant`
}
