% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contagion.R
\name{cont_test}
\alias{cont_test}
\title{Test for financial contagion}
\usage{
cont_test(lg_object_nc, lg_object_c,
  grid_range = quantile(rbind(lg_object_nc$x, lg_object_c$x), c(0.05,
  0.95)), grid_length = 30, n_rep = 1000, weight = function(y) {    
  rep(1, nrow(y)) })
}
\arguments{
\item{lg_object_nc}{An object of type \code{lg}, as produced by the
\code{lg_main}-function for the observations covering the non-crisis
period. The data must be two dimensional.}

\item{lg_object_c}{An object of type \code{lg}, as produced by the
\code{lg_main}-function for the observations covering the crisis period.
The data must be two dimensional.}

\item{grid_range}{This test measures the local correlations a long the
diagonal specified by this vector of length two.}

\item{grid_length}{The number of grid points.}

\item{n_rep}{The number of bootstrap replicates.}

\item{weight}{Weight function}
}
\value{
A list containing the test result as well as various parameters. The
  elements are:

  \itemize{
    \item \code{observed} The observed value of the test statistic.
    \item \code{replicated} The replicated values of the test statistic.
    \item \code{p_value} The p-value of the test.
    \item \code{local_correlations} The local correlations measured along the
     diagonal, for the non-crisis and crisis periods respectively.
  }
}
\description{
Test for financial contagion by means of the local Gaussian correlation.
}
\details{
This function is an implementation of the test for financial contagion
developed by Støve, Tjøstheim and Hufthammer (2013). They test whether the
local correlations between two financial time series are different before and
during crisis times. The distinction between crisis and non-crisis times must
be made by the user.
}
\examples{

   # Run the test on some built-in stock data
   data(EuStockMarkets)
   x <- apply(EuStockMarkets, 2, function(x) diff(log(x)))[, 1:2]

   # Define the crisis and non-crisis periods (arbitrarily for this simple
   # example)
   non_crisis <- x[1:100, ]
   crisis     <- x[101:200, ]

   # Create the lg-objects, with parameters that match the applications in the
   # original publication describibg the test
   lg_object_nc <- lg_main(non_crisis, est_method = "5par",
                           transform_to_marginal_normality = FALSE)
   lg_object_c  <- lg_main(crisis, est_method = "5par",
                           transform_to_marginal_normality = FALSE)

   \dontrun{
   # Run the test (with very few resamples for illustration)
   test_result <- cont_test(lg_object_nc, lg_object_c,
                            n_rep = 10)
   }

}
\references{
Støve, Bård, Dag Tjøstheim, and Karl Ove Hufthammer. "Using local Gaussian
   correlation in a nonlinear re-examination of financial contagion." Journal
   of Empirical Finance 25 (2014): 62-82.
}
