\name{exceedProbs}
\alias{exceedProbs}
\title{exceedProbs function}
\usage{
  exceedProbs(threshold, direction = "upper")
}
\arguments{
  \item{threshold}{vector of threshold levels for the
  indicator function}

  \item{direction}{default 'upper' giving exceedance
  probabilities, alternative is 'lower', which gives
  'subordinate probabilities'}
}
\value{
  a function of Y that computes the indicator function
  I(exp(Y)>threshold) evaluated for each cell of a matrix Y
  If several tresholds are specified an array is returned
  with the [,,i]th slice equal to I(exp(Y)>threshold[i])
}
\description{
  This function can be called using
  \code{MonteCarloAverage} (see \code{fun3} the examples in
  the help file for \link{MonteCarloAverage}). It computes
  exceedance probabilities,
  \deqn{P[\exp(Y_{t_1:t_2})>k],}{P[\exp(Y_{t_1:t_2})>k],}
  that is the probability that the relative reisk exceeds
  threshold \eqn{k}{k}. Note that it is possible to pass
  vectors of tresholds to the function, and the exceedance
  probabilities will be computed for each of these.
}
\seealso{
  \link{MonteCarloAverage}, \link{setoutput}
}

