% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-simulate.R
\name{sim.create_y}
\alias{sim.create_y}
\title{Simulate noisy observations}
\usage{
sim.create_y(noise_type, f, snr, phi, gamma, N_trials)
}
\arguments{
\item{noise_type}{Either "gaussian", "poisson", "nb" (negative binomial),
"binomial", or "bb" (beta-binomial).}

\item{f}{The underlying signal.}

\item{snr}{The desired signal-to-noise ratio. This argument is valid
only when \code{noise_type} is \code{"gaussian"}.}

\item{phi}{The inverse overdispersion parameter for negative binomial data.
The variance is \code{g + g^2/phi}.}

\item{gamma}{The dispersion parameter for beta-binomial data.}

\item{N_trials}{The number of trials parameter for binomial data.}
}
\value{
A list \code{out}, where
\itemize{
  \item \code{out$h} is \code{f} mapped through an inverse link function
  (times \code{N_trials} if \code{noise_type} is binomial or beta-binomial)
  \item \code{out$y} is the noisy response variable.
}
}
\description{
Simulate noisy observations
}
