% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_levels.R
\name{get_log_levels}
\alias{get_log_levels}
\alias{log_levels}
\alias{log_level}
\alias{add_log_levels}
\alias{remove_log_levels}
\title{Manage Log Levels}
\usage{
get_log_levels()

add_log_levels(levels)

remove_log_levels(level_names)
}
\arguments{
\item{levels}{a named \code{character} vector (see examples)}

\item{level_names}{a \code{character} vector of the names of the levels to remove}
}
\value{
a named \code{character} vector of the globally available log levels
(\code{add_log_levels()} and \code{remove_log_levels()} return invisibly).
}
\description{
Display, add and remove character labels for log levels.
}
\section{Default Log Levels}{


lgr comes with the following predefined log levels that are identical to
the log levels of log4j.

\tabular{rll}{
Level \tab Name  \tab Description \cr
\code{0} \tab off   \tab A log level of 0/off tells a Logger or Appender to suspend all logging \cr
\code{100} \tab fatal \tab Critical error that leads to program abort. Should always indicate a \code{stop()} or similar \cr
\code{200} \tab error \tab A severe error that does not trigger program abort\cr
\code{300} \tab warn  \tab A potentially harmful situation, like \code{warning()}\cr
\code{400} \tab info  \tab An informational message on the progress of the application\cr
\code{500} \tab debug \tab Finer grained informational messages that are mostly useful for debugging\cr
\code{600} \tab trace \tab An even finer grained message than debug\cr
\code{NA} \tab all   \tab A log level of NA/all tells a Logger or Appender to process all log events
}
}

\examples{
get_log_levels()
add_log_levels(c(errorish = 250))
get_log_levels()
remove_log_levels("errorish")
get_log_levels()

}
