% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{LayoutGlue}
\alias{LayoutGlue}
\title{Format Log Events as Text via glue}
\description{
Format a \link{LogEvent} as human readable text using \link[glue:glue]{glue::glue}. The function
is evaluated in an environment in which it has access to all elements of
the \link{LogEvent} (see examples). This is more flexible than \link{LayoutFormat},
but also more complex and slightly less performant.
}
\section{Usage}{
\preformatted{
x <- LayoutGlue$new(fmt = "{pad_right(colorize_levels(toupper(level_name)), 5)}
  [{timestamp}] msg")

x$clone(deep = FALSE)
x$format_event(event)
x$set_colors(x)
x$set_fmt(x)

x$fmt

}
}

\section{Creating a New LayoutGlue}{


A new \code{LayoutGlue} is instantiated with \code{LayoutGlue$new()}. It takes a single
argument \code{fmt} that is passed on to \code{glue::glue()} for each LogEvent.
}

\section{Fields}{


\describe{
\item{\code{fmt}}{see \code{\link[glue:glue]{glue::glue()}}}
}
}

\section{Methods}{


\describe{
\item{\code{format_event(event)}}{format a \link{LogEvent}}
}
}

\examples{
lg <- get_logger("test")$
  set_appenders(AppenderConsole$new())$
  set_propagate(FALSE)

lg$appenders[[1]]$set_layout(LayoutGlue$new())
lg$fatal("test")


# All fields of the LogEvent are available, even custom ones
lg$appenders[[1]]$layout$set_fmt(
  "{logger$name} {level_name}({level}) {caller}: {toupper(msg)} {{custom: {custom}}}"
)
lg$fatal("test", custom = "foobar")
lg$config(NULL)  # reset logger config

}
\seealso{
lgr exports a number of formatting utility functions that are
useful for layout glue: \code{\link[=colorize_levels]{colorize_levels()}}, \code{\link[=pad_left]{pad_left()}}, \code{\link[=pad_right]{pad_right()}}.

Other Layouts: \code{\link{LayoutDbi}},
  \code{\link{LayoutFormat}}, \code{\link{LayoutJson}},
  \code{\link{Layout}}
}
\concept{Layouts}
