% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{FilterForceLevel}
\alias{FilterForceLevel}
\title{Override the log level of all events processed by a Logger/Appender}
\description{
Overrides the log level of the  Appender/Logger that this filter
is attached to to with \code{level}. See also \code{\link[=with_log_level]{with_log_level()}}. It is
recommended to use filters that modify LogEvents only with Loggers, but
they will also work with Appenders.
}
\examples{
lg <- get_logger("test")

analyse <- function(){
  lg$add_filter(FilterForceLevel$new("info"), "force")
  on.exit(lg$remove_filter("force"))
  lg$error("an error with forced log level INFO")
}

analyse()
lg$error("an normal error")
lg$config(NULL)  # reset config
}
\section{Super class}{
\code{\link[lgr:EventFilter]{lgr::EventFilter}} -> \code{FilterForceLevel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{level}}{an \code{integer} \link[=log_level]{log level} used to override the log
levels of each \link{LogEvent} processed by this filter.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FilterForceLevel$new()}}
\item \href{#method-clone}{\code{FilterForceLevel$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new FilterForceLevel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterForceLevel$new(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{an \code{integer} or \code{character} \link[=log_level]{log level}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterForceLevel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
