% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderFileRotatingTime}
\alias{AppenderFileRotatingTime}
\title{Log to a time-stamped rotating file}
\description{
Log to a time-stamped rotating file

Log to a time-stamped rotating file
}
\seealso{
\link{AppenderFileRotatingDate}, \link{AppenderFileRotating}, \code{\link[rotor:rotate]{rotor::rotate()}}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderFile}},
\code{\link{AppenderTable}},
\code{\link{Appender}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderFile]{lgr::AppenderFile}} -> \code{\link[lgr:AppenderFileRotating]{lgr::AppenderFileRotating}} -> \code{AppenderFileRotating}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{cache_backups}}{\code{TRUE} or \code{FALSE}. If \code{TRUE} (the default) the list of backups is cached,
if \code{FALSE} it is read from disk every time this appender triggers.
Caching brings a significant speedup for checking whether to rotate or
not based on the \code{age} of the last backup, but is only safe if
there are no other programs/functions (except this appender) interacting
with the backups.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderFileRotating-new}{\code{AppenderFileRotatingTime$new()}}
\item \href{#method-AppenderFileRotating-rotate}{\code{AppenderFileRotatingTime$rotate()}}
\item \href{#method-AppenderFileRotating-set_age}{\code{AppenderFileRotatingTime$set_age()}}
\item \href{#method-AppenderFileRotating-set_fmt}{\code{AppenderFileRotatingTime$set_fmt()}}
\item \href{#method-AppenderFileRotating-set_overwrite}{\code{AppenderFileRotatingTime$set_overwrite()}}
\item \href{#method-AppenderFileRotating-set_cache_backups}{\code{AppenderFileRotatingTime$set_cache_backups()}}
\item \href{#method-AppenderFileRotating-format}{\code{AppenderFileRotatingTime$format()}}
\item \href{#method-AppenderFileRotating-clone}{\code{AppenderFileRotatingTime$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="show"><a href='../../lgr/html/AppenderFile.html#method-AppenderFile-show'><code>lgr::AppenderFile$show()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="append"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-append'><code>lgr::AppenderFileRotating$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="prune"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-prune'><code>lgr::AppenderFileRotating$prune()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_backup_dir"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_backup_dir'><code>lgr::AppenderFileRotating$set_backup_dir()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_compression"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_compression'><code>lgr::AppenderFileRotating$set_compression()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_create_file"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_create_file'><code>lgr::AppenderFileRotating$set_create_file()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_file"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_file'><code>lgr::AppenderFileRotating$set_file()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_max_backups"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_max_backups'><code>lgr::AppenderFileRotating$set_max_backups()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_size"><a href='../../lgr/html/AppenderFileRotating.html#method-AppenderFileRotating-set_size'><code>lgr::AppenderFileRotating$set_size()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$new(
  file,
  threshold = NA_integer_,
  layout = LayoutFormat$new(),
  filters = NULL,
  age = Inf,
  size = -1,
  max_backups = Inf,
  compression = FALSE,
  backup_dir = dirname(file),
  fmt = "\%Y-\%m-\%d--\%H-\%M-\%S",
  overwrite = FALSE,
  cache_backups = TRUE,
  create_file = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size, age, max_backups, compression, backup_dir, fmt, overwrite, cache_backups}}{see \code{\link[rotor:rotate]{rotor::rotate_time()}} for the meaning of these arguments. Note that
\code{fmt} corresponds to \code{format} and \code{backup_dir} to \code{dir}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$rotate(force = FALSE, now = Sys.time())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-set_age"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-set_age}{}}}
\subsection{Method \code{set_age()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_age(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-set_fmt"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-set_fmt}{}}}
\subsection{Method \code{set_fmt()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_fmt(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-set_overwrite"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-set_overwrite}{}}}
\subsection{Method \code{set_overwrite()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_overwrite(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-set_cache_backups"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-set_cache_backups}{}}}
\subsection{Method \code{set_cache_backups()}}{
set the \code{cache_backups} flag.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_cache_backups(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a \code{logical} scalar}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-format"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderFileRotating-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderFileRotating-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
