% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderDigest.R
\name{AppenderPushbullet}
\alias{AppenderPushbullet}
\title{Send push-notifications via RPushbullet}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
Send push notifications via \href{https://www.pushbullet.com/}{Pushbullet}. This
Appender keeps an in-memory buffer like \link[lgr:AppenderBuffer]{lgr::AppenderBuffer}. If the buffer is
flushed, usually because an event of specified magnitude is encountered, all
buffered events are concatenated to a single message that is sent to
\code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}. The default behavior is to push the last 7 log
events in case a \code{fatal} event is encountered.
}
\examples{
if (requireNamespace("RPushbullet") && !is.null(getOption("rpushbullet.key")) ){
  app <- AppenderPushbullet$new()

  lg <- lgr::get_logger("test/dbi")$
    add_appender(app, "pb")$
    set_propagate(FALSE)

  lg$fatal("info")
  lg$fatal("test")

 invisible(lg$config(NULL))
}
}
\seealso{
\link[lgr:LayoutFormat]{lgr::LayoutFormat}, \link[lgr:LayoutGlue]{lgr::LayoutGlue}

Other Appenders: 
\code{\link{AppenderAWSCloudWatchLog}},
\code{\link{AppenderDbi}},
\code{\link{AppenderDt}},
\code{\link{AppenderDynatrace}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPool}},
\code{\link{AppenderSendmail}},
\code{\link{AppenderSyslog}}

Other Digest Appenders: 
\code{\link{AppenderDigest}},
\code{\link{AppenderMail}},
\code{\link{AppenderSendmail}}
}
\concept{Appenders}
\concept{Digest Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{\link[lgrExtra:AppenderDigest]{lgrExtra::AppenderDigest}} -> \code{AppenderPushbullet}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{apikey}}{see \code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}}

\item{\code{recipients}}{see \code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}}

\item{\code{email}}{see \code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}}

\item{\code{channel}}{see \code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}}

\item{\code{devices}}{see \code{\link[RPushbullet:pbPost]{RPushbullet::pbPost()}}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderPushbullet-new}{\code{AppenderPushbullet$new()}}
\item \href{#method-AppenderPushbullet-flush}{\code{AppenderPushbullet$flush()}}
\item \href{#method-AppenderPushbullet-set_apikey}{\code{AppenderPushbullet$set_apikey()}}
\item \href{#method-AppenderPushbullet-set_recipients}{\code{AppenderPushbullet$set_recipients()}}
\item \href{#method-AppenderPushbullet-set_email}{\code{AppenderPushbullet$set_email()}}
\item \href{#method-AppenderPushbullet-set_channel}{\code{AppenderPushbullet$set_channel()}}
\item \href{#method-AppenderPushbullet-set_devices}{\code{AppenderPushbullet$set_devices()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-append'><code>lgr::AppenderMemory$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-clear'><code>lgr::AppenderMemory$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="format"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-format'><code>lgr::AppenderMemory$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_buffer_size'><code>lgr::AppenderMemory$set_buffer_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_exit'><code>lgr::AppenderMemory$set_flush_on_exit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_rotate'><code>lgr::AppenderMemory$set_flush_on_rotate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_threshold'><code>lgr::AppenderMemory$set_flush_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_should_flush'><code>lgr::AppenderMemory$set_should_flush()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="show"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-show'><code>lgr::AppenderMemory$show()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderDigest" data-id="set_subject_layout"><a href='../../lgrExtra/html/AppenderDigest.html#method-AppenderDigest-set_subject_layout'><code>lgrExtra::AppenderDigest$set_subject_layout()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$new(
  threshold = NA_integer_,
  flush_threshold = "fatal",
  layout = LayoutFormat$new(fmt = "\%K  \%t> \%m \%f", timestamp_fmt = "\%H:\%M:\%S"),
  subject_layout = LayoutFormat$new(fmt = "[LGR] \%L: \%m"),
  buffer_size = 6,
  recipients = NULL,
  email = NULL,
  channel = NULL,
  devices = NULL,
  apikey = getOption("rpushbullet.key"),
  filters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold, flush_threshold, layout, buffer_size}}{see \link[lgr:AppenderBuffer]{lgr::AppenderBuffer}}

\item{\code{subject_layout}}{A \link[lgr:LayoutFormat]{lgr::LayoutFormat} object.}

\item{\code{recipients, email, channel, devices, apikey}}{see \link[RPushbullet:pbPost]{RPushbullet::pbPost}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-flush"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-flush}{}}}
\subsection{Method \code{flush()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$flush()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-set_apikey"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-set_apikey}{}}}
\subsection{Method \code{set_apikey()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$set_apikey(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-set_recipients"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-set_recipients}{}}}
\subsection{Method \code{set_recipients()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$set_recipients(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-set_email"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-set_email}{}}}
\subsection{Method \code{set_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$set_email(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-set_channel"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-set_channel}{}}}
\subsection{Method \code{set_channel()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$set_channel(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPushbullet-set_devices"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPushbullet-set_devices}{}}}
\subsection{Method \code{set_devices()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPushbullet$set_devices(x)}\if{html}{\out{</div>}}
}

}
}
