% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{get_polynomial_expansions}
\alias{get_polynomial_expansions}
\title{Generate Design Matrix with Polynomial and Interaction Terms}
\usage{
get_polynomial_expansions(
  predictors,
  numerics,
  just_linear_with_interactions,
  just_linear_without_interactions,
  exclude_interactions_for = NULL,
  include_quadratic_terms = TRUE,
  include_cubic_terms = TRUE,
  include_quartic_terms = FALSE,
  include_2way_interactions = TRUE,
  include_3way_interactions = TRUE,
  include_quadratic_interactions = FALSE,
  exclude_these_expansions = NULL,
  custom_basis_fxn = NULL,
  ...
)
}
\arguments{
\item{predictors}{Numeric matrix of predictor variables}

\item{numerics}{Integer vector; column indices for variables to expand as polynomials}

\item{just_linear_with_interactions}{Integer vector; column indices for variables to keep linear but allow interactions}

\item{just_linear_without_interactions}{Integer vector; column indices for variables to keep linear without interactions}

\item{exclude_interactions_for}{Integer vector; column indices to exclude from all interactions}

\item{include_quadratic_terms}{Logical; whether to include squared terms (default TRUE)}

\item{include_cubic_terms}{Logical; whether to include cubic terms (default TRUE)}

\item{include_quartic_terms}{Logical; whether to include 4th degree terms (default FALSE)}

\item{include_2way_interactions}{Logical; whether to include two-way interactions (default TRUE)}

\item{include_3way_interactions}{Logical; whether to include three-way interactions (default TRUE)}

\item{include_quadratic_interactions}{Logical; whether to include interactions with squared terms (default TRUE)}

\item{exclude_these_expansions}{Character vector; names of specific terms to exclude from final matrix}

\item{custom_basis_fxn}{Function; optional custom basis expansion function that accepts all arguments listed here except itself}

\item{...}{Additional arguments passed to \code{custom_basis_fxn}}
}
\value{
Matrix with columns for intercept, polynomial terms, and specified interactions
}
\description{
Internal function for creating a design matrix containing polynomial
expansions and interaction terms for predictor variables. Supports
customizable term generation including polynomial degrees up to quartic
terms, interaction types, and selective term exclusion.

Column names take on the form "_v_" for linear terms, "_v_^d" for polynomial
powers up to d = 4, and "_v_x_w_" for interactions between variables v and w,
where v and w are column indices of the input predictor matrix.

The \code{custom_basis_fxn} argument, if supplied, requires the same arguments
as this function, in the same order, minus the eponymous argument,
"custom_basis_fxn".
}
\keyword{internal}
