% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{get_isbn_10_check_digit}
\alias{get_isbn_10_check_digit}
\title{Get ISBN 10 check digit}
\usage{
get_isbn_10_check_digit(x, allow.hyphens = FALSE, errors.as.nas = FALSE)
}
\arguments{
\item{x}{A string of 9 or 10 digits}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{errors.as.nas}{return NA if error instead of throwing error}
}
\value{
Returns the character check digit that satifies the
        mod 11 condition. Returns "X" if 10. Returns NA if input is NA
}
\description{
Takes a string representation of an ISBN 10
and returns the check digit that satisfies the necessary condition.
It can take a 10 digit string (and ignore the already extant check digit)
or a 9 digit string (without the last digit)
}
\examples{

get_isbn_10_check_digit("012491540X")
get_isbn_10_check_digit("0-124-91540-X", allow.hyphens=TRUE)

# nine digit string
get_isbn_10_check_digit("900403781")

get_isbn_10_check_digit("onetwothre", errors.as.nas=TRUE)  # NA

# vectorized
get_isbn_10_check_digit(c("012491540X", "9004037810", "900403781"))

}
