% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-attributes.R
\name{fread_plus_date}
\alias{fread_plus_date}
\title{Read a file and set a special libbib date attribute}
\usage{
fread_plus_date(fname, allow.fallback.date = TRUE, ...)
}
\arguments{
\item{fname}{The file name to read}

\item{allow.fallback.date}{A logical indicating whether, if no
matching file name with a date is found,
to use today's date as the date attribute.
Default is \code{TRUE}.}

\item{...}{Arbitrary arguments to use with \code{fread}}
}
\value{
A \code{data.table} with an attribute called \code{lb.date} set
}
\description{
Takes a file name, reads it with \code{data.table::fread}, and
sets an attribute called \code{lb.date} with a date extracted
from the file name.
}
\details{
The file name can be one with a valid ISO 8601 date (yyyy-mm-dd)
already in it, or it can be a file name with the date elided.

For example, if there is a file you'd like to read on your disk
called "iris-2021-05-08.csv", you can call this function with
either "iris.csv" or "iris-2021-05-08.csv" as the file name.

When you call this function with a file name without an ISO 8601
date (e.g. "iris.csv.gz"),  the file name extension ".csv.gz" is
removed and the function looks for a file name beginning with
"iris", a date, and the file extension. The file extension is
considered to be anything after the first period in the base name.
For example, if the file name given is "./my.data/iris.csv.gz", the
extension is ".csv.gz". This means no period can be present in
the base file name (after any directories) with the exception of
the file extension.

If you call this function with "iris.csv" and there is no file name
with an ISO 8601 date appended to that file name on your disk, and
\code{allow.fallback.date} is \code{TRUE}, then the \code{lb.date}
attribute is set to the current date.
}
\examples{
\dontrun{
  # there's a file called "iris-2021-05-08.csv" on disk
  dat <- fread_plus_date("iris.csv")
  attribute(dat)$lb.date
  # [1] "2021-05-08

  # can also read the full file name
  dat <- fread_plus_date("iris-2021-05-08.csv")
  attribute(dat)$lb.date
  # [1] "2021-05-08
}

}
