% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libproj-package.R
\name{libproj_version}
\alias{libproj_version}
\alias{libproj_has_libtiff}
\alias{libproj_has_libcurl}
\alias{libproj_default_writable_dir}
\alias{libproj_default_data_dir}
\alias{with_libproj_configuration}
\alias{libproj_configuration}
\alias{warn_for_configuration}
\alias{libproj_configure}
\title{PROJ configuration}
\usage{
libproj_version()

libproj_has_libtiff()

libproj_has_libcurl()

libproj_default_writable_dir()

libproj_default_data_dir()

with_libproj_configuration(config, expr)

libproj_configuration()

warn_for_configuration()

libproj_configure(
  search_path = c(system.file("proj", package = "libproj"),
    getOption("libproj.search_path", libproj_default_data_dir())),
  db_path = getOption("libproj.db_path", system.file("proj/proj.db", package =
    "libproj")),
  ca_bundle_path = NA,
  network_endpoint = getOption("libproj.network_endpoint", "https://cdn.proj.org"),
  network_enabled = getOption("libproj.network_enabled", FALSE),
  log_level = getOption("libproj.log_level", 1L),
  restore_previous_on_error = TRUE
)
}
\arguments{
\item{config}{A named \code{list()} with elements used to temporarily override elements of the
current \code{\link[=libproj_configuration]{libproj_configuration()}}.}

\item{expr}{An expression to evaluate with the specified state}

\item{search_path}{A character vector of paths where libproj will
look for resource files (e.g., gridshift, database, init files).
Defaults to the internal database and init files distributed
with the PROJ source.}

\item{db_path}{Independent of \code{search_path}, a character vector of
SQLite databases that may contain updated or alternative
coordinate operations from the default proj.db included in this
package. You must specify at least one database as part of this configuration;
do not rely on \code{search_path} to find this value for you.}

\item{ca_bundle_path}{A directory that contains the certificate bundle when
network is enabled. Can be \code{NA}.}

\item{network_endpoint}{A mirror of the PROJ CDN of gridshift files. By default,
this is set to \url{https://cdn.proj.org}.}

\item{network_enabled}{Whether or not to download gridshift files on the fly.
This defaults to \code{FALSE}.}

\item{log_level}{An integer describing the log level: 0 (none), 1 (error), 2 (debug),
3 (trace), or 4 (tell)}

\item{restore_previous_on_error}{Use \code{FALSE} to skip resetting the previous configuration
if the configuration fails.}
}
\value{
\itemize{
\item \code{libproj_version()}: A character vector of the proj release.
\item \code{libproj_has_libtiff()}: \code{TRUE} if built against libtiff, \code{FALSE} otherwise.
\item \code{libproj_has_libcurl()}: \code{TRUE} if built against curl, \code{FALSE} otherwise.
\item \code{libproj_default_writable_dir()}: A character vector of the path where libproj-specific
tempfiles are written.
\item \code{libproj_default_data_dir()}: A character vector of the path where the default PROJ-data
installation is kept.
\item \code{libproj_configuration()}: A \code{list()} of values that can be passed to
\code{libproj_configure()}.
\item \code{with_libproj_configuration()}: The value of \code{expr}.
\item \code{libproj_configure()}: \code{NULL}, invisibly.
}
}
\description{
PROJ configuration
}
\examples{
libproj_version()
libproj_configuration()

}
