/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_SO_H
#define _SO_SO_H

#include <so/PharmMLRef.h>
#include <so/SOBlock.h>

/** \struct so_SO
	 \brief A structure representing an SO element
*/
typedef struct so_SO so_SO;

/** \memberof so_SO
 * Create a new empty so_SO structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_SO_copy, so_SO_free
 */
so_SO *so_SO_new();
/** \memberof so_SO
 * Create a copy of a so_SO structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_SO_new
 */
so_SO *so_SO_copy(so_SO *self);
/** \memberof so_SO
 * Free all memory associated with a so_SO structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_SO_new
 */
void so_SO_free(so_SO *self);
void so_SO_ref(so_SO *self);
void so_SO_unref(so_SO *self);
/** \memberof so_SO
 * Get the value of the id attribute
 * \param self - pointer to a so_SO
 * \return A pointer to the attribute value
 * \sa so_SO_set_id
 */
char *so_SO_get_id(so_SO *self);
/** \memberof so_SO
 * Set the value of the id attribute
 * \param self - pointer to a so_SO
 * \param value - A pointer to the attribute value
 * \return 0 for success
 * \sa so_SO_get_id
 */
int so_SO_set_id(so_SO *self, char *value);
/** \memberof so_SO
 * Get the value of the metadataFile attribute
 * \param self - pointer to a so_SO
 * \return A pointer to the attribute value
 * \sa so_SO_set_metadataFile
 */
char *so_SO_get_metadataFile(so_SO *self);
/** \memberof so_SO
 * Set the value of the metadataFile attribute
 * \param self - pointer to a so_SO
 * \param value - A pointer to the attribute value
 * \return 0 for success
 * \sa so_SO_get_metadataFile
 */
int so_SO_set_metadataFile(so_SO *self, char *value);
/** \memberof so_SO
 * Get the Description element
 * \param self - pointer to a so_SO
 * \return A pointer to the Description string
 * \sa so_SO_set_Description
 */
char *so_SO_get_Description(so_SO *self);
/** \memberof so_SO
 * Get the PharmMLRef element
 * \param self - pointer to a so_SO
 * \return A pointer to the structure representing the PharmMLRef element
 * \sa so_SO_set_PharmMLRef
 */
so_PharmMLRef *so_SO_get_PharmMLRef(so_SO *self);
/** \memberof so_SO
 * Get the SOBlock element
 * \param self - pointer to a so_SO
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the SOBlock element
 * \sa so_SO_set_SOBlock
 */
so_SOBlock *so_SO_get_SOBlock(so_SO *self, int number);
/** \memberof so_SO
 * Get the number of SOBlock currently contained in the SO structure
 * \param self - pointer to a so_SO
 * \return The number of SOBlocks
 */
int so_SO_get_number_of_SOBlock(so_SO *self);
/** \memberof so_SO
 * Set the Description element
 * \param self - pointer to a so_SO
 * \param value - A pointer to a \a string to set.
 * \return 0 for success
 * \sa so_SO_get_Description
 */
int so_SO_set_Description(so_SO *self, char *value);
/** \memberof so_SO
 * Set the PharmMLRef element
 * \param self - pointer to a so_SO
 * \param value - A pointer to a \a so_PharmMLRef to set.
 * \sa so_SO_get_PharmMLRef
 */
void so_SO_set_PharmMLRef(so_SO *self, so_PharmMLRef *value);
/** \memberof so_SO
 * Create a new PharmMLRef element and insert it into the so_SO
 * \param self - pointer to a so_SO
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_PharmMLRef *so_SO_create_PharmMLRef(so_SO *self);
/** \memberof so_SO
 * Create a new SOBlock element and insert it into the so_SO
 * \param self - pointer to a so_SO
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_SOBlock *so_SO_create_SOBlock(so_SO *self);
int so_SO_add_SOBlock(so_SO *self, so_SOBlock *child);
int so_SO_remove_SOBlock(so_SO *self, int index);

#endif
