% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_readLAScatalog.r
\name{readLAScatalog}
\alias{readLAScatalog}
\alias{catalog}
\title{Create an object of class LAScatalog}
\usage{
readLAScatalog(folder, progress = FALSE, ...)

catalog(folder, ...)
}
\arguments{
\item{folder}{string. The path of a folder containing a set of las/laz files. Can also be a vector of
file paths.}

\item{progress}{boolean. Display a progress bar.}

\item{\dots}{Extra parameters to \link[base:list.files]{list.files}. Typically `recursive = TRUE`.}
}
\value{
A \code{LAScatalog} object
}
\description{
Create an object of class \link[lidR:LAScatalog-class]{LAScatalog} from a folder or a set of filenames.
A LAScatalog is a representation of a set of las/laz files. A computer cannot load all the data at
once. A \code{LAScatalog} is a simple way to manage all the files sequentially. Most functions from
\code{lidR} can be used seamlessly with a LAScatalog using the internal \code{LAScatalog} processing
engine. To take advantage of the \code{LAScatalog} processing engine the user must first adjust some
processing options using the \link[lidR:catalog_options_tools]{appropriated functions}. Careful
reading of the \link[lidR:LAScatalog-class]{LAScatalog class documentation} is required to use the
\code{LAScatalog} class correctly.\cr\cr \code{catalog()} is softly deprecated for \code{readLAScatalog()}.
}
\examples{
# A single file LAScatalog using data provided with the package
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
ctg = readLAScatalog(LASfile)
plot(ctg)

\dontrun{
ctg <- readLAScatalog("/path/to/a/folder/of/las/files")

# Internal engine will sequentially process chunks of size 500 x 500 m (clusters)
opt_chunk_size(ctg) <- 500

# Internal engine will align the 500 x 500 m chunks on x = 250 and y = 300
opt_alignment(ctg) <- c(250, 300)

# Internal engine will not display a progress estimation
opt_progress(ctg) <- FALSE

# Internal engine will not return results into R. Instead it will write results in files.
opt_output_files(ctg) <- "/path/to/folder/templated_filename_{XBOTTOM}_{ID}"

# More details in the documentation
help("LAScatalog-class", "lidR")
help("catalog_options_tools", "lidR")
}
}
