% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-spi.R
\name{tin}
\alias{tin}
\title{Spatial Interpolation Algorithm}
\usage{
tin(..., extrapolate = knnidw(1, 1, 50))
}
\arguments{
\item{...}{unused}

\item{extrapolate}{There are usually a few points outside the convex hull, determined by the ground
points at the very edge of the dataset, that cannot be interpolated with a triangulation.
Extrapolation is done using the nearest neighbour approach by default using \link{knnidw}.}
}
\description{
This function is made to be used in \link{grid_terrain} or \link{normalize_height}. It implements an algorithm
for spatial interpolation. Spatial interpolation is based on a Delaunay triangulation, which performs
a linear interpolation within each triangle. There are usually a few points outside the convex hull,
determined by the ground points at the very edge of the dataset, that cannot be interpolated with
a triangulation. Extrapolation is done using the nearest neighbour approach.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile)

# plot(las)

dtm = grid_terrain(las, algorithm = tin())

plot(dtm, col = terrain.colors(50))
plot_dtm3d(dtm)
}
\seealso{
Other spatial interpolation algorithms: 
\code{\link{knnidw}()},
\code{\link{kriging}()}
}
\concept{spatial interpolation algorithms}
