% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_select.R
\name{catalog_select}
\alias{catalog_select}
\title{Select LAS files manually from a LAScatalog}
\usage{
catalog_select(
  ctg,
  mapview = TRUE,
  method = c("subset", "flag_unprocessed", "flag_processed")
)
}
\arguments{
\item{ctg}{A \link[=LAScatalog-class]{LAScatalog} object}

\item{mapview}{logical. If \code{FALSE}, use R base plot instead of mapview (no pan, no zoom, see
also \link[=plot]{plot})}

\item{method}{character. By default selecting tiles that are a subset of the catalog. It is also possible to flag
the files to maintain the catalog as a whole but process only a subset of its content.
\code{flag_unprocessed} enables users to point and click on files that will not be processed.
\code{flag_processed} enables users to point and click on files that will be processed.}
}
\value{
A LAScatalog object
}
\description{
Select a set of LAS tiles from a LAScatalog interactively using the mouse. This function
allows users to subset a LAScatalog by clicking on a map of the file.
}
\examples{
\dontrun{
ctg = readLAScatalog("<Path to a folder containing a set of .las files>")
new_ctg = catalog_select(ctg)
}
}
