% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/utils_colors.R
\name{plot}
\alias{plot}
\alias{plot,LAS,missing-method}
\alias{plot,LAScatalog,missing-method}
\alias{plot,LASheader,missing-method}
\alias{height.colors}
\alias{forest.colors}
\alias{random.colors}
\alias{pastel.colors}
\title{Plot a LAS* object}
\usage{
plot(x, y, ...)

\S4method{plot}{LAS,missing}(
  x,
  y,
  ...,
  color = "Z",
  pal = "auto",
  bg = "black",
  breaks = "pretty",
  nbreaks = "auto",
  backend = "rgl",
  clear_artifacts = TRUE,
  axis = FALSE,
  legend = FALSE,
  add = FALSE,
  voxel = FALSE,
  NAcol = "lightgray"
)

\S4method{plot}{LAScatalog,missing}(x, y, mapview = FALSE, chunk_pattern = FALSE, overlaps = FALSE, ...)

\S4method{plot}{LASheader,missing}(x, y, mapview = FALSE, ...)

height.colors(n)

forest.colors(n)

random.colors(n)

pastel.colors(n)
}
\arguments{
\item{x}{A \code{LAS*} object}

\item{y}{Unused (inherited from R base)}

\item{...}{Will be passed to \link[rgl:3dobjects]{points3d} (LAS) or \link[graphics:plot.default]{plot}
if \code{mapview = FALSE} or to \link[mapview:mapView]{mapview} if \code{mapview = TRUE} (LAScatalog).}

\item{color}{characters. The attribute used to color the point cloud. Default is Z coordinates. RGB
is an allowed string even if it refers to three attributes simultaneously.}

\item{pal}{palette function, similar to heat.colors, or palette values. Default is \code{"auto"}
providing an automatic coloring depending on the attribute \code{color}}

\item{bg}{The color for the background. Default is black.}

\item{breaks}{either a numeric vector with the actual breaks, or a name of a method accepted
by the style argument of \link[classInt:classIntervals]{classIntervals}}

\item{nbreaks}{Number of colors breaks.}

\item{backend}{character. Can be \code{"rgl"} or \code{"lidRviewer"}. If \code{"rgl"} is chosen
the display relies on the \code{rgl} package. If \code{"lidRviewer"} is chosen it relies on the
\code{lidRviewer} package, which is much more efficient and can handle million of points
using less memory. \code{lidRviewer} is not available on CRAN yet and should
be installed from github (see. \url{https://github.com/Jean-Romain/lidRviewer}).}

\item{clear_artifacts}{logical. It is a known and documented issue that the 3D visualisation with
\code{rgl} displays artifacts. The points look aligned and/or regularly spaced in some view angles.
This is because \code{rgl} computes with single precision \code{float}. To fix that the point
cloud is shifted to (0,0) to reduce the number of digits needed to represent its coordinates.
The drawback is that the point cloud is not plotted at its actual coordinates.}

\item{axis}{logical. Display axis on XYZ coordinates.}

\item{legend}{logical. Display a gradient colour legend.}

\item{add}{If \code{FALSE} normal behaviour otherwise must be the output of a prior plot function
to enable the alignment of a second point cloud.}

\item{voxel}{boolean or numeric. Displays voxels instead of points. Useful to render the output
of \link{voxelize_points}, for example. However it is computationally demanding to render and can
easily take 15 seconds for 10000 voxels. It should be reserved for small scenes. If boolean the voxel
resolution is guessed automatically. Otherwise users can provide the size of the voxels. To reduce the rendering time,
an internal optimization removes voxels that are not visible when surrounded by other voxels.}

\item{NAcol}{a color for NA values.}

\item{mapview}{logical. If \code{FALSE} the catalog is displayed in a regular plot from R base.}

\item{chunk_pattern}{logical. Display the current chunk pattern used to process the catalog.}

\item{overlaps}{logical. Highlight the overlaps between files.}

\item{n}{The number of colors (> 1) to be in the palette}
}
\description{
Plot displays a 3D interactive windows based on rgl for \link{LAS} objects\cr\cr
Plot displays an interactive view for \link[=LAScatalog-class]{LAScatalog} objects with pan and
zoom capabilities based on \link[mapview:mapview-package]{mapview}. If the coordinate reference
system (CRS) of the \code{LAScatalog} is non empty, the plot can be displayed on top of base maps
(satellite data, elevation, street, and so on).\cr\cr
Plot displays a \link[=LASheader-class]{LASheader} object exactly like it displays a LAScatalog
object.
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)

plot(las)
plot(las, color = "Intensity")
plot(las, color = "ScanAngleRank", pal = rainbow)

# If outliers break the color range, use the breaks parameter
las$Intensity[150] <- 1000L
plot(las, color = "Intensity")
plot(las, color = "Intensity", breaks = "quantile", nbreaks = 50)

plot(las, color = "Classification")

# This dataset is already tree segmented
plot(las, color = "treeID")
plot(las, color = "treeID", pal = random.colors)


# single file LAScatalog using data provided in lidR
ctg = readLAScatalog(LASfile)
plot(ctg)
plot(ctg, map = T, map.types = "Esri.WorldImagery")
}

}
