% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{cleanRaster}
\alias{cleanRaster}
\title{Applies thresholds and mask to a rasterLayer object}
\usage{
cleanRaster(rast, minmax = c(-Inf, +Inf), mask = NULL)
}
\arguments{
\item{rast}{raster object.}

\item{minmax}{vector of two numeric values. minimum and maximum thresholds to apply to `rast` values}

\item{mask}{raster object. mask to be applied (multiplication with input raster `rast`)}
}
\value{
a raster object
}
\description{
Applies a lower and upper thresholds to the values of the input raster. If the mask input is provided, first all NA values in the raster are set to 0, then the raster in multiplied by the mask. Cells to be masked should therefore have a NA value in the mask raster object.
}
\examples{
# load data
data(quatremontagnes)
# build model
ABA.model <- lidaRtRee::ABAmodel(quatremontagnes$G.m2.ha,
quatremontagnes[, 9:76], transform = "boxcox")
# build example raster to apply model
quatremontagnes$X <- rep(1:8, 12)
quatremontagnes$Y <- rep(1:12, each = 8)
metrics.map <- raster::rasterFromXYZ(quatremontagnes[, c(2,3,9:76)])
predict.map <- lidaRtRee::ABApredict(ABA.model, metrics.map)
# create raster mask
mask <- predict.map
# set values to 1 or NA
raster::values(mask) <- rep(c(1, 1, NA), each = 32)
# apply thresholds and mask
predict.map.clean <- cleanRaster(predict.map, c(40, 70), mask)

# plot maps
raster::plot(predict.map, main = "Predictions")
raster::plot(mask, main = "Mask", legend = FALSE)
raster::plot(predict.map.clean, main = "Cleaned predictions")
}
