% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cloudTreeMetrics}
\alias{cloudTreeMetrics}
\title{Computes metrics on trees detected in list of point clouds.}
\usage{
cloudTreeMetrics(llasn, XY, plot.radius, res = 0.5, func, ...)
}
\arguments{
\item{llasn}{list of \code{\link[lidR]{LAS}} objects}

\item{XY}{a dataframe or matrix with XY coordinates of plot centers}

\item{plot.radius}{numeric. plot radius in meters}

\item{res}{numeric. resolution of canopy height model computed with \code{\link{points2DSM}} before tree segmentation}

\item{func}{a function to be applied to the attributes of extracted trees (return from internal call to \code{\link{treeExtraction}} function) to compute plot level metrics}

\item{...}{other parameters to be passed to \code{\link{treeSegmentation}}}
}
\value{
a dataframe with tree metrics in columns corresponding to LAS objects of the list (lines)
}
\description{
Extracts summary statistics on trees for each LAS object in a list:
}
\details{
\itemize{
\item{calls \code{\link{treeSegmentation}} to segment trees and then \code{\link{treeExtraction}} to extract their features}
\item{computes `TreeCanopy.coverInPlot` (proportion of surface of disk of interest which is covered by segmented trees), `TreeCanopy.meanHeightInPlot` (mean canopy height inside intersection of tree segments and disk of interest)}
\item{removes detected trees located outside of the disk of interest defined by their centers and radius}
\item{computes summary statistics of extracted tree features based on a user-defined function (default is \code{\link{stdTreeMetrics}})}
}
}
\examples{
data(laschablais3)

# extract three point clouds of 10 m radius from LAS object
llas <- list()
llas[[1]] <- lidR::clip_circle(laschablais3, 974350, 6581680, 10)
llas[[2]] <- lidR::clip_circle(laschablais3, 974390, 6581680, 10)
llas[[3]] <- lidR::clip_circle(laschablais3, 974350, 6581640, 10)
# normalize point clouds
llas <- lapply(llas, function(x) {lidR::normalize_height(x, lidR::tin())})

# compute tree metrics restricted to disks of radius 8 m.
cloudTreeMetrics(llas, 
                 cbind(c(974350, 974390, 974350), c(6581680, 6581680, 6581640)),
                 8, res=0.5)

# compute metrics with user-defined function
# number of detected trees between 20 and 30 meters and their mean height
user.func <- function(x)
{
  dummy <- x$h[which(x$h>20 & x$h<30)]
  data.frame(Tree.between.20.30=length(dummy), Tree.meanH=mean(dummy))
}
 cloudTreeMetrics(llas,
                  cbind(c(974350, 974390, 974350), c(6581680, 6581680, 6581640)),
                  8, res=0.5, func=user.func)
}
\seealso{
\code{\link{treeSegmentation}}, \code{\link{treeExtraction}}, \code{\link{stdTreeMetrics}}
}
