% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{maximaSelection}
\alias{maximaSelection}
\title{Image maxima selection based on values and neighborhood of local maxima}
\usage{
maximaSelection(maxi, dem.nl, hmin = 0, dmin = 0, dprop = 0)
}
\arguments{
\item{maxi}{cimg object or RasterLayer object. image with local maxima (typically output from \code{\link{maximaDetection}}, image values correspond to neighborhood radius on which pixels are global maxima in the initial image)}

\item{dem.nl}{cimg object. initial image from which maxima were detected}

\item{hmin}{numeric. minimum value in initial image for a maximum to be selected}

\item{dmin}{numeric. intercept term for selection of maxima depending on neighborhood radius: \code{maxi >= dmin + dem.nl * dprop}}

\item{dprop}{numeric. proportional term for selection of maxima depending on neighborhood radius: \code{maxi >= dmin + dem.nl * dprop}}
}
\value{
A cimg object or rasterLayer object which values are the radius (n) in meter of the square window (width 2n+1) where the center pixel is global maximum and which fulfill the selection criteria
}
\description{
In a maxima image (output of \code{\link{maximaDetection}}), sets values to zero for pixels which
\enumerate{
\item value in the initial image (from which maxima were detected) are below a threshold 
\item values in the maxima image (corresponding to the radius of the neighborhood where they are global maxima) are below a threshold depending on the initial image value.
}
}
\examples{
data(chmchablais3)

# maxima detection
maxi <- maximaDetection(chmchablais3)

# several maxima selection settings
selected.maxi.hmin <- maximaSelection(maxi, chmchablais3, hmin=15)
selected.maxi.dm <- maximaSelection(maxi, chmchablais3, dm=2.5)
selected.maxi <- maximaSelection(maxi, chmchablais3, dm=1, dprop=0.1)

# corresponding count number of remaining maxima
table(raster::values(maxi))
table(raster::values(selected.maxi.hmin))
table(raster::values(selected.maxi.dm))
table(raster::values(selected.maxi))

# plot original image
raster::plot(chmchablais3, main="Initial image")

# plot maxima images, original and first case
raster::plot(maxi, main="Local maxima")
raster::plot(selected.maxi, main="Selected maxima")

}
\seealso{
\code{\link{maximaDetection}}
}
