% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{rasters2Cor}
\alias{rasters2Cor}
\title{Correlation between two rasters}
\usage{
rasters2Cor(raster.b, raster.s, mask = NULL, small.SC = TRUE)
}
\arguments{
\item{raster.b}{raster. raster to correlate with largest extent}

\item{raster.s}{raster. raster to correlate with smallest extent}

\item{mask}{raster. mask of area to correlate}

\item{small.SC}{boolean. is the small raster already standardized and centered ?}
}
\value{
A numeric
}
\description{
computes correlation between two rasters, based on the extent of the smallest one.
}
\examples{
# create raster
r.b <- raster::raster()
raster::extent(r.b) <- c(0,40,0,40)
raster::res(r.b) <- 1
xy <- raster::xyFromCell(r.b,1:length(r.b))

# add Gaussian surface and noise
z <- 3*exp(-((xy[,1]-20)^2+(xy[,2]-20)^2/2)/6)
r.b <- raster::rasterFromXYZ(cbind(xy,z))

# create circular mask of radius 5
z.mask <- (xy[,1]-20)^2 + (xy[,2]-20)^2 < 5^2
r.mask <- raster::rasterFromXYZ(cbind(xy, z.mask))

# create small raster of size 20
r.s <- raster::crop(r.b, raster::extent(c(10,30,10,30)))

# add noise to small raster
raster::values(r.s) <- raster::values(r.s) + rnorm(length(r.s),0,0.5)
r.mask <- raster::crop(r.mask, raster::extent(c(10,30,10,30)))

# compute correlation on masked area where signal to noise ratio is lower
rasters2Cor(r.b, r.s, r.mask, small.SC=FALSE)

# compute correlation for whole small raster
rasters2Cor(r.b, r.s, small.SC=FALSE)

# display large raster
raster::plot(r.b, main="Large raster")
# display small raster
raster::plot(r.s, main="Small raster")
# display mask
raster::plot(r.mask, main="Computation mask")
}
\seealso{
\code{\link{rastersMovingCor}} to compute correlation between rasters for different translations
}
