% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect.R
\name{expect_deprecated}
\alias{expect_deprecated}
\alias{expect_defunct}
\title{Does expression produce lifecycle warnings or errors?}
\usage{
expect_deprecated(expr, regexp = NULL, ...)

expect_defunct(expr)
}
\arguments{
\item{expr}{Expression that should produce a lifecycle warning or
error.}

\item{regexp}{Optional regular expression matched against the
expected warning message.}

\item{...}{
  Arguments passed on to \code{\link[testthat:expect_match]{expect_match}}
  \describe{
    \item{\code{perl}}{logical.  Should Perl-compatible regexps be used?}
    \item{\code{fixed}}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
  }}
}
\description{
These functions are equivalent to \code{\link[testthat:expect_error]{testthat::expect_warning()}} and
\code{\link[testthat:expect_error]{testthat::expect_error()}} but check specifically for lifecycle
warnings or errors.

To test whether a deprecated feature still works without causing a
deprecation warning, set the \code{lifecycle_verbosity} option to
\code{"quiet"}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{test_that("feature still works", \{
  withr::local_options(lifecycle_verbosity = "quiet")
  expect_true(my_deprecated_function())
\})
}\if{html}{\out{</div>}}
}
\details{
\code{expect_deprecated()} sets the \link[=verbosity]{lifecycle_verbosity}
option to \code{"warning"} to enforce deprecation warnings which are
otherwise only shown once every 8 hours.
}
