% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{l_plot}
\alias{l_plot}
\title{Plot each variable vs each measure of interest}
\usage{
l_plot(dataset = NA, person, variables, measures, time_var = NA)
}
\arguments{
\item{dataset}{dataset from create_dataset that contains all variables
and measures of interest}

\item{person}{an instantiated Person object}

\item{variables}{list of variables in person of interest, with structure 
list(source1 = c(var1, var2), source2 = c(var3, var4))
where source is a source of data as defined in a Person
object, and var1 and var2 are variables from source1, 
while var3 and var4 are variables from source2}

\item{measures}{list of measures in person of interest, with structure 
list(source1 = c(var1, var2), source2 = c(var3, var4))
where source is a source of data as defined in a Person
object, and var1 and var2 are variables from source1, 
while var3 and var4 are variables from source2}

\item{time_var}{the time variable that variables and measures are 
observed in (time, date, or datetime) - only needed if 
dataset is not passed in}
}
\value{
NULL - plots for each variable vs each measure are printed
}
\description{
Plots each variable vs each measure listed. Can pass in a 
dataset from create_dataset, or function calls create_dataset itself.
}
\examples{
data(EX)

l_plot(person = EX, variables = list("fitbit_daily" = c("sleepDuration",
                                                        "steps", "distance"),
                                     "util" = c("day_of_week", "day_type")), 
       measures = list("fitbit_daily" = c("restingHeartRate")),
       time_var = c("date"))

dataset <- create_dataset(person = EX, all_variables = list(
                                               "util" = c("month"),
                                               "fitbit_daily" = c("steps")),
                                       time_var = c("date"))
                                       
l_plot(dataset, person = EX, variables = list("util" = c("month")),
       measures = list("fitbit_daily" = c("steps")))
       
       
}
