% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift.R
\name{lift}
\alias{lift}
\title{Containerize R Markdown Documents}
\usage{
lift(input = NULL, output_dir = NULL)
}
\arguments{
\item{input}{Input (R Markdown) file.}

\item{output_dir}{Directory to output \code{Dockerfile}.
If not provided, will be the same directory as \code{input}.}
}
\value{
\code{Dockerfile}.
}
\description{
Containerize R Markdown documents. This function generates
\code{Dockerfile} based on the liftr metadata in the RMD document.
}
\details{
After running \link{lift}, run \link{render_docker} on the document to
render the Dockerized R Markdown document using Docker containers.
See \code{vignette('liftr-intro')} for details about the extended
YAML front-matter metadata format used by liftr.
}
\examples{
# copy example file
dir_example = paste0(tempdir(), '/liftr-minimal/')
dir.create(dir_example)
file.copy(system.file("examples/liftr-minimal.Rmd", package = "liftr"), dir_example)

# containerization
input = paste0(dir_example, "liftr-minimal.Rmd")
lift(input)

\dontrun{
# render the document with Docker
render_docker(input)

# view rendered document
browseURL(paste0(dir_example, "liftr-minimal.html"))

# purge the generated Docker image
purge_image(paste0(dir_example, "liftr-minimal.docker.yml"))}
}

