% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{setinfo}
\alias{setinfo}
\alias{setinfo.lgb.Dataset}
\title{Set information of an \code{lgb.Dataset} object}
\usage{
setinfo(dataset, ...)

\method{setinfo}{lgb.Dataset}(dataset, name, info, ...)
}
\arguments{
\item{dataset}{Object of class \code{lgb.Dataset}}

\item{...}{other parameters}

\item{name}{the name of the field to get}

\item{info}{the specific field of information to set}
}
\value{
the dataset you passed in

the dataset you passed in
}
\description{
Set one attribute of a \code{lgb.Dataset}
}
\details{
The \code{name} field can be one of the following:

\itemize{
    \item{\code{label}: vector of labels to use as the target variable}
    \item{\code{weight}: to do a weight rescale}
    \item{\code{init_score}: initial score is the base prediction lightgbm will boost from}
    \item{\code{group}: used for learning-to-rank tasks. An integer vector describing how to
        group rows together as ordered results from the same set of candidate results to be ranked.
        For example, if you have a 1000-row dataset that contains 250 4-document query results,
        set this to \code{rep(4L, 250L)}}
}
}
\examples{
\donttest{
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
lgb.Dataset.construct(dtrain)

labels <- lightgbm::getinfo(dtrain, "label")
lightgbm::setinfo(dtrain, "label", 1 - labels)

labels2 <- lightgbm::getinfo(dtrain, "label")
stopifnot(all.equal(labels2, 1 - labels))
}
}
