% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.prognosis.R
\name{lilikoi.prognosis}
\alias{lilikoi.prognosis}
\title{Pathway-based prognosis model}
\usage{
lilikoi.prognosis(
  event,
  time,
  exprdata,
  percent = NULL,
  alpha = 1,
  nfold = 5,
  method = "median",
  cvlambda = "lambda.1se",
  python.path = NULL,
  path = NULL,
  coxnnet = FALSE,
  coxnnet_method = "gradient"
)
}
\arguments{
\item{event}{survival event}

\item{time}{survival time}

\item{exprdata}{dataset for penalization, with id in the rownames and pathway or metabolites
names in the column names.}

\item{percent}{train-test separation percentage}

\item{alpha}{denote which penalization method to use.}

\item{nfold}{fold number for cross validation}

\item{method}{determine the prognosis index, "quantile", "quantile" or "ratio".}

\item{cvlambda}{determine the lambda for prediction, "lambda.min" or "lambda.1se".}

\item{python.path}{saved path for python3}

\item{path}{saved path for the inst file in lilikoi2}

\item{coxnnet}{if TRUE, coxnnet will be used.}

\item{coxnnet_method}{the algorithm for gradient descent. Includes standard gradient descent ("gradient"), Nesterov accelerated gradient "nesterov" and momentum gradient descent ("momentum").}
}
\value{
A list of components: \item{c_index}{C-index of the Cox-PH model} \item{difftest}{Test results of the survival curve difference test}
\item{survp}{Kaplan Meier plot}
}
\description{
Fits a Cox proportional hazards regression model or a Cox neural network model
to predict survival results.
}
\examples{
\donttest{
inst.path = path.package('lilikoi2', quiet = FALSE) # path = "lilikoi/inst/", use R to run
inst.path = file.path(inst.path, 'inst')
python.path = "/Library/Frameworks/Python.framework/Versions/3.8/bin/python3"
lilikoi.prognosis(event, time, exprdata, percent=NULL, alpha=0, nfold=5, method="median",
  cvlambda=NULL,python.path=NULL, path=inst.path, python.path=python.path,
  coxnnet=FALSE,coxnnet_method="gradient")
}
}
