% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.machine_learning.r
\name{lilikoi.machine_learning}
\alias{lilikoi.machine_learning}
\title{A machine learning Function}
\usage{
lilikoi.machine_learning(
  MLmatrix = PDSmatrix,
  measurementLabels = Label,
  significantPathways = selected_Pathways_Weka,
  trainportion = 0.8,
  cvnum = 10,
  dlround = 50,
  nrun = 10,
  Rpart = TRUE,
  LDA = TRUE,
  SVM = TRUE,
  RF = TRUE,
  GBM = TRUE,
  PAM = TRUE,
  LOG = TRUE,
  DL = TRUE
)
}
\arguments{
\item{MLmatrix}{selected pathway deregulation score or metabolites expression matrix}

\item{measurementLabels}{measurement label for samples}

\item{significantPathways}{selected pathway names}

\item{trainportion}{train percentage of the total sample size}

\item{cvnum}{number of folds}

\item{dlround}{epoch number for the deep learning method}

\item{nrun}{denotes the total number of runs of each method to get their averaged performance metrics}

\item{Rpart}{TRUE if run Rpart method}

\item{LDA}{TRUE if run LDA method}

\item{SVM}{TRUE if run SVM method}

\item{RF}{TRUE if run random forest method}

\item{GBM}{TRUE if run GBM method}

\item{PAM}{TRUE if run PAM method}

\item{LOG}{TRUE if run LOG method}

\item{DL}{TRUE if run deep learning method}
}
\value{
Evaluation results and plots of all 8 machine learning algorithms, along with variable importance plots.
}
\description{
This function for classification using 8 different machine learning algorithms
and it plots the ROC curves and the AUC, SEN, and specificty
}
\examples{
\donttest{
dt = lilikoi.Loaddata(file=system.file("extdata","plasma_breast_cancer.csv", package = "lilikoi"))
Metadata <- dt$Metadata
# lilikoi.machine_learning(MLmatrix = Metadata, measurementLabels = Metadata$Label,
# significantPathways = 0,
# trainportion = 0.8, cvnum = 10, dlround=50,Rpart=TRUE,
# LDA=FALSE,SVM=FALSE,RF=FALSE,GBM=FALSE,PAM=FALSE,LOG=FALSE,DL=FALSE)
}
}
\keyword{classifcation}
