% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_plot.R
\name{plot.lyl_range}
\alias{plot.lyl_range}
\title{Plot Life Years Lost at a range of different ages}
\usage{
\method{plot}{lyl_range}(x, colors = NA, ...)
}
\arguments{
\item{x}{An object of class \code{lyl_range} (obtained with function \code{lyl_range}).}

\item{colors}{Vector with one color for each cause of death. Default is NA, and
default colors are used.}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
A plot with age-specific life expectancy and life years lost.
}
\description{
\code{plot} for objects of class \code{lyl_range} creates a figure of Life Years Lost
at a range of different ages.
}
\examples{
# Load simulated data as example
data(simu_data)

\donttest{
# Estimate remaining life expectancy and Life Years
# Lost due to specific causes of death after each age
# from 30 to 40 years and before age 95 years
lyl_estimation <- lyl_range(data = simu_data, t = age_death, status = cause_death,
                             age_begin = 30, age_end = 40, tau = 95)

# Summarize and plot the data
plot(lyl_estimation)
plot(lyl_estimation, colors = c("chocolate", "cornflowerblue"))

# The plot can be modified with a usual ggplot2 format
plot(lyl_estimation) +
  ggplot2::xlab("Age [in years]") +
  ggplot2::ggtitle("Life Years Lost at ages 30-40 years")

}
}
\seealso{
\itemize{
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
}

% @references \itemize{
    % \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition. \emph{In preparation}.}
% }
}
