% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_next_step.R
\name{what_trans}
\alias{what_trans}
\title{what_trans}
\usage{
what_trans(
  model = NULL,
  trans_df = NULL,
  variable = NULL,
  data = NULL,
  r2_diff = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{model}{Model object}

\item{trans_df}{\code{data.frame}}

\item{variable}{string or character vector of variable names contained in raw_data \code{data.frame}}

\item{data}{\code{data.frame} containing data from analysis}

\item{r2_diff}{A boolean to determine whether to add a column to compare new and original model R2}

\item{verbose}{A boolean to specify whether to print warnings}
}
\value{
\code{data.frame} mapping variables' transformations to the respective model's statistics.
}
\description{
run models with additional (transformed) variables from the data
}
\details{
Run a separate model for each combination of transformations specified.
Then, for each model run, return that model's fit and the variables' statistics.
}
\examples{
run_model(data = mtcars,dv = 'mpg',ivs = c('disp','cyl')) \%>\%
what_trans(variable = 'cyl',trans_df = data.frame(
name = c('diminish', 'decay', 'lag', 'ma', 'log', 'hill', 'sin', 'exp'),
func = c('linea::diminish(x,a)',
         'linea::decay(x,a)',
         'linea::lag(x,a)',
         'linea::ma(x,a)',
         'log(x,a)',
         "linea::hill_function(x,a,b,c)",
         'sin(x*a)',
         '(x^a)'),order = 1:8) \%>\%
  dplyr::mutate(val = '') \%>\%
  dplyr::mutate(val = dplyr::if_else(condition = name == 'hill',
                                     '(1,5,50),(1 ,5,50),(1,5,50)',
                                     val)))
}
