% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_linelist.R
\name{make_linelist}
\alias{make_linelist}
\title{Create a linelist from a data.frame}
\usage{
make_linelist(x, ..., allow_extra = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} or a \code{tibble} containing case line list data, with
cases in rows and variables in columns}

\item{...}{a series of tags provided as \code{tag_name = "column_name"}, where
\code{tag_name} indicates any of the known variables listed in 'Details';
alternatively, a named \code{list} of variables to be tagged, where names
indicate the types of variable (to be selected from \code{\link[=tags_names]{tags_names()}}), and
values indicate their name in the input \code{data.frame}; see details for a
list of known variable types and their expected content}

\item{allow_extra}{a \code{logical} indicating if additional data tags not
currently recognized by \code{linelist} should be allowed; if \code{FALSE}, unknown
tags will trigger an error}
}
\value{
The function returns a \code{linelist} object.
}
\description{
This function converts a \code{data.frame} or a \code{tibble} into a \code{linelist} object,
where different types of epidemiologically relevant data are tagged. This
includes dates of different events (e.g. onset of symptoms, case reporting),
information on the patient (e.g. age, gender, location) as well as other
informations such as the type of case (e.g. confirmed, probable) or the
outcome of the disease. The output will seem to be the same \code{data.frame}, but
\code{linelist}-aware packages will then be able to automatically use tagged
fields for further data cleaning and analysis.
}
\details{
Known variable types include:
\itemize{
\item \code{id}: a unique case identifier as \code{numeric} or \code{character}
\item \code{date_onset}: date of symptom onset (see below for date formats)
\item \code{date_reporting}: date of case notification (see below for date formats)
\item \code{date_admission}: date of hospital admission (see below for date formats)
\item \code{date_discharge}: date of hospital discharge (see below for date formats)
\item \code{date_outcome}: date of disease outcome (see below for date formats)
\item \code{date_death}: date of death (see below for date formats)
\item \code{gender}: a \code{factor} or \code{character} indicating the gender of the patient
\item \code{age}: a \code{numeric} indicating the age of the patient, in years
\item \code{location}: a \code{factor} or \code{character} indicating the location of the
patient
\item \code{occupation}: a \code{factor} or \code{character} indicating the professional
activity of the patient
\item \code{hcw}: a \code{logical} indicating if the patient is a health care worker
\item \code{outcome}: a \code{factor} or \code{character} indicating the outcome of the disease
(death or survival)
}

Dates can be provided in the following formats/types:
\itemize{
\item \code{Date} objects (e.g. using \code{as.Date} on a \code{character} with a correct date
format); this is the recommended format
\item \code{POSIXct/POSIXlt} objects (when a finer scale than days is needed)
\item \code{numeric} values, typically indicating the number of days since the first
case
}
}
\examples{

if (require(outbreaks)) {

  ## dataset we will convert to linelist
  head(measles_hagelloch_1861)

  ## create linelist
  x <- make_linelist(measles_hagelloch_1861,
    id = "case_ID",
    date_onset = "date_of_prodrome",
    age = "age",
    gender = "gender"
  )

  ## print result - just first few entries
  head(x)

  ## check tags
  tags(x)
}

}
\seealso{
\itemize{
\item An overview of the \link{linelist} package * \code{\link[=tags_names]{tags_names()}}: for a list of known
tag names * \code{\link[=tags_types]{tags_types()}}: for the associated accepted types/classes *
\code{\link[=tags]{tags()}}: for a list of tagged variables in a \code{linelist} * \code{\link[=set_tags]{set_tags()}}: for
modifying tags * \code{\link[=tags_df]{tags_df()}}: for selecting variables by tags
}
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
