% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tags}
\alias{tags}
\title{Get the list of tags in a linelist}
\usage{
tags(x, show_null = FALSE)
}
\arguments{
\item{x}{a \code{linelist} object}

\item{show_null}{a \code{logical} indicating if the complete list of tags,
including \code{NULL} ones, should be returned; if \code{FALSE}, only tags with a
non-NULL value are returned; defaults to \code{FALSE}}
}
\value{
The function returns a named \code{list} where names indicate generic
types of data, and values indicate which column they correspond to.
}
\description{
This function returns the list of tags identifying specific variable types in
a \code{linelist}.
}
\details{
Tags are stored as the \code{tags} attribute of the object.
}
\examples{

if (require(outbreaks)) {
  ## make a linelist
  x <- make_linelist(measles_hagelloch_1861, date_onset = "date_of_prodrome")

  ## check non-null tags
  tags(x)

  ## get a list of all tags, including NULL ones
  tags(x, TRUE)
}

}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
