% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lineupdist.R
\name{plot.lineupdist}
\alias{plot.lineupdist}
\title{Plot summary of inter-individual distances}
\usage{
\method{plot}{lineupdist}(x, breaks = NULL, add.rug = TRUE, what = c("both", "ss", "sn"), ...)
}
\arguments{
\item{x}{Output of \code{\link[=distee]{distee()}} or \code{\link[=disteg]{disteg()}}.}

\item{breaks}{Optional vector of breaks, passed to
\code{\link[graphics:hist]{graphics::hist()}}, though if it is length 1, we interpret it as
the number of breaks and ensure that both histograms use the same set of
breaks.}

\item{add.rug}{If true, also include \code{\link[graphics:rug]{graphics::rug()}} below
histograms.}

\item{what}{Indicates whether to plot both self-self and self-nonself
distances (or correlations) or just one or the other.  (\code{"ss"}
indicates self-self and \code{"sn"} indicates self-nonself.)}

\item{\dots}{Ignored at this point.}
}
\value{
None.
}
\description{
Plot histograms of self-self and self-nonself distances from a distance
matrix calculated by \code{\link[=distee]{distee()}} or \code{\link[=disteg]{disteg()}}.
}
\details{
We call \code{\link[=pulldiag]{pulldiag()}} and \code{\link[=omitdiag]{omitdiag()}} to get the
self-self and self-nonself distances.

If all of the self-self distances are missing, we plot just the self-nonself
distances.
}
\examples{
data(expr1, expr2)

\dontshow{expr1 <- expr1[,1:500]
expr2 <- expr2[,1:500]}

# distance as correlation
d <- distee(expr1, expr2, "cor")

# plot histograms of self-self and self-nonself correlations
plot(d)

}
\seealso{
\code{\link[=pulldiag]{pulldiag()}}, \code{\link[=distee]{distee()}},
\code{\link[=plot2dist]{plot2dist()}}
}
\author{
Karl W Broman, \email{broman@wisc.edu}
}
\keyword{utilities}
