% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lang.country.R
\name{lang.country}
\alias{lang.country}
\title{Get languages by country}
\usage{
lang.country(x, list = FALSE, glottolog.source = "modified")
}
\arguments{
\item{x}{character vector of the countries (can be written in lower case)}

\item{list}{logical. If TRUE, returns a list of languages, if FALSE return a vector.}

\item{glottolog.source}{A character vector that define which glottolog database is used: 'original' or 'modified' (by default)}
}
\description{
Takes any vector of countries and return languages.
}
\examples{
lang.country('North Korea')
lang.country(c('North Korea', 'Luxembourg'))
lang.country(c('North Korea', 'Luxembourg'), list = TRUE)
}
\seealso{
\code{\link{lang.aff}}, \code{\link{lang.iso}}
}
\author{
George Moroz <agricolamz@gmail.com>
}
