% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link2giKarim.R
\name{linkAll}
\alias{linkAll}
\title{convenient function to establish all link2GI links}
\usage{
linkAll(
  links = NULL,
  simple = TRUE,
  linkItems = c("saga", "grass7", "otb", "gdal"),
  sagaArgs = "default",
  grassArgs = "default",
  otbArgs = "default",
  gdalArgs = "default",
  quiet = FALSE
)
}
\arguments{
\item{links}{character. links}

\item{simple}{logical. true  make all}

\item{linkItems}{character. list of c("saga","grass7","otb","gdal")}

\item{sagaArgs}{character. full string of sagaArgs}

\item{grassArgs}{character. grassArgs full string of grassArgs}

\item{otbArgs}{character. full string of otbArgs}

\item{gdalArgs}{character. full string of gdalArgs}

\item{quiet}{supress all messages default is FALSE}
}
\description{
brute force search, find and linkl of all link2GI link functions. This is helpfull if yor system is well setup and the standard linkage procedure will provide the correct linkages.
}
\note{
You may also use the full list of arguments that is made available from the \code{link2GI} package, but it is strongly recommended in this case to use directly the single linkage functions from  \code{link2GI}.
}
\examples{
\dontrun{
# required packages
require(uavRst)
require(link2GI)

# search, find and create the links to all supported  GI software
giLinks<-uavRst::linkAll()

# makes the GDAL linkage verbose
giLinks<-uavRst::linkAll(gdalArgs= "quiet = TRUE") 

}
}
