% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{setup_leaflet_observers}
\alias{setup_leaflet_observers}
\title{Setup Leaflet Map Observers}
\usage{
setup_leaflet_observers(
  component_id,
  session,
  components,
  shared_state,
  on_selection_change,
  registry = NULL
)
}
\arguments{
\item{component_id}{Character string. The unique identifier for the Leaflet component.}

\item{session}{'shiny' session object for the current user session.}

\item{components}{List containing component configuration data including data reactives
and shared ID columns.}

\item{shared_state}{Reactive values object containing selected_id and selection_source
for coordinating selections across components.}

\item{on_selection_change}{Function to call when selection changes (currently unused).}

\item{registry}{Optional registry object with set_selection method for managing
selections. If NULL, falls back to direct shared_state updates.}
}
\value{
List containing two observer objects:
\item{observer1}{Handles marker click events on the map}
\item{observer2}{Responds to selection changes from other components}
}
\description{
\code{setup_leaflet_observers} creates two observers for handling Leaflet map interactions in a linked component system.
The first observer handles direct marker clicks on the map, while the second observer
responds to selection changes from other linked components.
}
\details{
The marker click observer:
\itemize{
\item Extracts clicked marker ID from the click event
\item Retrieves corresponding data row from the component's data
\item Clears existing popups and applies click behavior (custom or default)
\item Updates selection state through registry or direct shared_state modification
}

The selection response observer:
\itemize{
\item Only responds to selections from other components (not self-selections)
\item Updates the map visualization to reflect the new selection
}
}
